/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.redis.RedisComponent;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisConsumer;
import org.apache.camel.component.redis.RedisProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="spring-redis", title="Spring Redis", syntax="spring-redist:host:port", consumerClass=RedisConsumer.class, label="spring,nosql")
public class RedisEndpoint
extends DefaultEndpoint {
    @UriParam
    private RedisConfiguration configuration;

    public RedisEndpoint(String uri, RedisComponent component, RedisConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new RedisProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RedisConsumer answer = new RedisConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.configuration.stop();
    }

    public RedisConfiguration getConfiguration() {
        return this.configuration;
    }
}

