/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import javax.xml.stream.XMLStreamReader;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.stax.StaxStreamXMLReader;
import org.apache.camel.util.ExchangeHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class StAXProcessor
implements Processor {
    private final Class<ContentHandler> contentHandlerClass;

    public StAXProcessor(Class<ContentHandler> contentHandlerClass) {
        this.contentHandlerClass = contentHandlerClass;
    }

    public void process(Exchange exchange) throws Exception {
        InputSource is = (InputSource)exchange.getIn().getMandatoryBody(InputSource.class);
        XMLStreamReader stream = (XMLStreamReader)exchange.getIn().getMandatoryBody(XMLStreamReader.class);
        StaxStreamXMLReader reader = new StaxStreamXMLReader(stream);
        ContentHandler handler = this.contentHandlerClass.newInstance();
        reader.setContentHandler(handler);
        reader.parse(is);
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            exchange.getOut().setBody((Object)handler);
        } else {
            exchange.getIn().setBody((Object)handler);
        }
    }
}

