/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.swagger.ExchangeRestApiResponseAdapter;
import org.apache.camel.swagger.RestSwaggerSupport;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSwaggerProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerProcessor.class);
    private final BeanConfig swaggerConfig;
    private final RestSwaggerSupport support;
    private final String contextIdPattern;
    private final boolean contextIdListing;
    private final RestConfiguration configuration;

    public RestSwaggerProcessor(String contextIdPattern, boolean contextIdListing, Map<String, Object> parameters, RestConfiguration configuration) {
        this.contextIdPattern = contextIdPattern;
        this.contextIdListing = contextIdListing;
        this.configuration = configuration;
        this.support = new RestSwaggerSupport();
        this.swaggerConfig = new BeanConfig();
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        this.support.initSwagger(this.swaggerConfig, parameters);
    }

    public void process(Exchange exchange) throws Exception {
        String contextId = exchange.getContext().getName();
        String route = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        String accept = (String)exchange.getIn().getHeader("Accept", String.class);
        ExchangeRestApiResponseAdapter adapter = new ExchangeRestApiResponseAdapter(exchange);
        boolean json = false;
        boolean yaml = false;
        if (route != null && route.endsWith("/swagger.json")) {
            json = true;
            route = route.substring(0, route.length() - 13);
        } else if (route != null && route.endsWith("/swagger.yaml")) {
            yaml = true;
            route = route.substring(0, route.length() - 13);
        }
        if (accept != null && !json && !yaml) {
            json = accept.toLowerCase(Locale.US).contains("json");
            yaml = accept.toLowerCase(Locale.US).contains("yaml");
        }
        if (!json && !yaml) {
            json = true;
        }
        try {
            if (this.contextIdListing && (ObjectHelper.isEmpty((Object)route) || route.equals("/"))) {
                this.support.renderCamelContexts(adapter, contextId, this.contextIdPattern, json, yaml, this.configuration);
            } else {
                String name;
                if (ObjectHelper.isNotEmpty((Object)route)) {
                    if (route.startsWith("/")) {
                        route = route.substring(1);
                    }
                    name = route.split("/")[0];
                    if (route.startsWith(contextId)) {
                        route = route.substring(name.length());
                    }
                } else {
                    name = exchange.getContext().getName();
                }
                boolean match = true;
                if (this.contextIdPattern != null) {
                    match = "#name#".equals(this.contextIdPattern) ? name.equals(contextId) : EndpointHelper.matchPattern((String)name, (String)this.contextIdPattern);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Match contextId: {} with pattern: {} -> {}", new Object[]{name, this.contextIdPattern, match});
                    }
                }
                if (!match) {
                    adapter.noContent();
                } else {
                    this.support.renderResourceListing(adapter, this.swaggerConfig, name, route, json, yaml, exchange.getIn().getHeaders(), exchange.getContext().getClassResolver(), this.configuration);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error rendering Swagger API due " + e.getMessage(), (Throwable)e);
        }
    }
}

