/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 1024;
    public static final int MAX_PORT_NUMBER = 49151;
    private static AtomicInteger currentMinPort = new AtomicInteger(1024);

    private AvailablePortFinder() {
    }

    public static synchronized int getNextAvailable() {
        int next = AvailablePortFinder.getNextAvailable(currentMinPort.get());
        currentMinPort.set(next + 1);
        return next;
    }

    public static synchronized int getNextAvailable(int fromPort) {
        if (fromPort < currentMinPort.get() || fromPort > 49151) {
            throw new IllegalArgumentException("Invalid start currentMinPort: " + fromPort);
        }
        for (int i = fromPort; i <= 49151; ++i) {
            if (!AvailablePortFinder.available(i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an available currentMinPort above " + fromPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        if (port < currentMinPort.get() || port > 49151) {
            throw new IllegalArgumentException("Invalid start currentMinPort: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

