/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.wasm;

import com.dylibso.chicory.runtime.Module;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.wasm.WasmFunction;
import org.apache.camel.wasm.WasmSupport;

public class WasmExpression
extends ExpressionAdapter
implements ExpressionResultTypeAware {
    private final String expression;
    private String module;
    private String resultTypeName;
    private Class<?> resultType;
    private String headerName;
    private String propertyName;
    private TypeConverter typeConverter;
    private WasmFunction function;

    public WasmExpression(String expression) {
        this.expression = expression;
    }

    public void init(CamelContext camelContext) {
        super.init(camelContext);
        if (this.module == null) {
            throw new IllegalArgumentException("Module must be configured");
        }
        this.typeConverter = camelContext.getTypeConverter();
        if (this.resultTypeName != null && (this.resultType == null || this.resultType == Object.class)) {
            this.resultType = camelContext.getClassResolver().resolveClass(this.resultTypeName);
        }
        if (this.resultType == null || this.resultType == Object.class) {
            this.resultType = byte[].class;
        }
        ResourceLoader rl = PluginHelper.getResourceLoader((CamelContext)camelContext);
        Resource res = rl.resolveResource(this.module);
        try (InputStream is = res.getInputStream();){
            this.function = new WasmFunction(Module.builder((InputStream)is).build(), this.expression);
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getExpressionText() {
        return this.expression;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange, Object.class);
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).asBoolean();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return false;
    }

    public Object evaluate(Exchange exchange) {
        try {
            byte[] in = WasmSupport.serialize(exchange);
            byte[] result = this.function.run(in);
            return this.typeConverter.convertTo(this.resultType, exchange, (Object)result);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

