/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.java5.IgnoreProperty;
import org.apache.cxf.aegis.type.java5.XmlAttribute;
import org.apache.cxf.aegis.type.java5.XmlElement;
import org.apache.cxf.aegis.type.java5.XmlFlattenedArray;
import org.apache.cxf.aegis.type.java5.XmlParamType;
import org.apache.cxf.aegis.type.java5.XmlReturnType;
import org.apache.cxf.aegis.type.java5.XmlType;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationReader {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationReader.class);
    private static final Class<? extends Annotation> WEB_PARAM = AnnotationReader.load("javax.jws.WebParam");
    private static final Class<? extends Annotation> WEB_RESULT = AnnotationReader.load("javax.jws.WebResult");
    private static final Class<? extends Annotation> XML_ATTRIBUTE = AnnotationReader.load("javax.xml.bind.annotation.XmlAttribute");
    private static final Class<? extends Annotation> XML_ELEMENT = AnnotationReader.load("javax.xml.bind.annotation.XmlElement");
    private static final Class<? extends Annotation> XML_SCHEMA = AnnotationReader.load("javax.xml.bind.annotation.XmlSchema");
    private static final Class<? extends Annotation> XML_TYPE = AnnotationReader.load("javax.xml.bind.annotation.XmlType");
    private static final Class<? extends Annotation> XML_TRANSIENT = AnnotationReader.load("javax.xml.bind.annotation.XmlTransient");

    public boolean isIgnored(AnnotatedElement element) {
        return AnnotationReader.isAnnotationPresent(element, IgnoreProperty.class, XML_TRANSIENT);
    }

    public boolean isAttribute(AnnotatedElement element) {
        return AnnotationReader.isAnnotationPresent(element, XmlAttribute.class, XML_ATTRIBUTE);
    }

    public boolean isElement(AnnotatedElement element) {
        return AnnotationReader.isAnnotationPresent(element, XmlElement.class, XML_ELEMENT);
    }

    public Boolean isNillable(AnnotatedElement element) {
        return Boolean.TRUE.equals(AnnotationReader.getAnnotationValue("nillable", element, Boolean.FALSE, XmlElement.class, XML_ELEMENT));
    }

    public static Boolean isNillable(Annotation[] anns) {
        if (anns == null) {
            return null;
        }
        return (Boolean)AnnotationReader.getAnnotationValue("nillable", anns, XmlElement.class, XML_ELEMENT);
    }

    public Class<?> getType(AnnotatedElement element) {
        Class value = (Class)AnnotationReader.getAnnotationValue("type", element, AegisType.class, XmlAttribute.class, XmlElement.class);
        if (value == null) {
            value = (Class)AnnotationReader.getAnnotationValue("type", element, XmlElement.DEFAULT.class, XML_ELEMENT);
        }
        return value;
    }

    public Class<?> getParamType(Method method, int index) {
        return (Class)AnnotationReader.getAnnotationValue("type", method, index, AegisType.class, XmlParamType.class);
    }

    public Class<?> getReturnType(AnnotatedElement element) {
        return (Class)AnnotationReader.getAnnotationValue("type", element, AegisType.class, XmlReturnType.class);
    }

    public String getName(AnnotatedElement element) {
        String name = (String)AnnotationReader.getAnnotationValue("name", element, "", XmlType.class, XmlAttribute.class, XmlElement.class);
        if (name == null) {
            name = (String)AnnotationReader.getAnnotationValue("name", element, "##default", XML_TYPE, XML_ATTRIBUTE, XML_ELEMENT);
        }
        return name;
    }

    public String getParamTypeName(Method method, int index) {
        return (String)AnnotationReader.getAnnotationValue("name", method, index, AegisType.class, XmlParamType.class);
    }

    public String getReturnTypeName(AnnotatedElement element) {
        return (String)AnnotationReader.getAnnotationValue("name", element, "", XmlReturnType.class);
    }

    public String getNamespace(AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        String namespace = (String)AnnotationReader.getAnnotationValue("namespace", element, "", XmlType.class, XmlAttribute.class, XmlElement.class, XML_SCHEMA);
        if (namespace == null) {
            namespace = (String)AnnotationReader.getAnnotationValue("namespace", element, "##default", XML_TYPE, XML_ATTRIBUTE, XML_ELEMENT);
        }
        return namespace;
    }

    public String getParamNamespace(Method method, int index) {
        String namespace = (String)AnnotationReader.getAnnotationValue("namespace", method, index, "", XmlParamType.class);
        if (namespace == null) {
            namespace = (String)AnnotationReader.getAnnotationValue("targetNamespace", method, index, "", WEB_PARAM);
        }
        return namespace;
    }

    public String getReturnNamespace(AnnotatedElement element) {
        String namespace = (String)AnnotationReader.getAnnotationValue("namespace", element, "", XmlReturnType.class);
        if (namespace == null) {
            namespace = (String)AnnotationReader.getAnnotationValue("targetNamespace", element, "", WEB_RESULT);
        }
        return namespace;
    }

    public int getMinOccurs(AnnotatedElement element) {
        String minOccurs = (String)AnnotationReader.getAnnotationValue("minOccurs", element, "", XmlElement.class);
        if (minOccurs != null) {
            return Integer.parseInt(minOccurs);
        }
        Boolean required = (Boolean)AnnotationReader.getAnnotationValue("required", element, null, XML_ELEMENT);
        if (Boolean.TRUE.equals(required)) {
            return 1;
        }
        return 0;
    }

    public static Integer getMinOccurs(Annotation[] anns) {
        if (anns == null) {
            return null;
        }
        String minOccurs = (String)AnnotationReader.getAnnotationValue("minOccurs", anns, XmlElement.class);
        if (minOccurs != null) {
            return Integer.valueOf(minOccurs);
        }
        Boolean required = (Boolean)AnnotationReader.getAnnotationValue("required", anns, XML_ELEMENT);
        if (Boolean.TRUE.equals(required)) {
            return 1;
        }
        return null;
    }

    public boolean isExtensibleElements(AnnotatedElement element, boolean defaultValue) {
        Boolean extensibleElements = (Boolean)AnnotationReader.getAnnotationValue("extensibleElements", element, Boolean.TRUE, XmlType.class);
        if (extensibleElements == null) {
            return defaultValue;
        }
        return extensibleElements;
    }

    public boolean isExtensibleAttributes(AnnotatedElement element, boolean defaultValue) {
        Boolean extensibleAttributes = (Boolean)AnnotationReader.getAnnotationValue("extensibleAttributes", element, Boolean.TRUE, XmlType.class);
        if (extensibleAttributes == null) {
            return defaultValue;
        }
        return extensibleAttributes;
    }

    private static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (annotation == null || !element.isAnnotationPresent(annotation.asSubclass(Annotation.class))) continue;
            return true;
        }
        return false;
    }

    static Object getAnnotationValue(String name, AnnotatedElement element, Object ignoredValue, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (annotation == null) continue;
            try {
                Annotation ann = element.getAnnotation(annotation.asSubclass(Annotation.class));
                if (ann == null) continue;
                Method method = ann.getClass().getMethod(name, new Class[0]);
                Object value = method.invoke((Object)ann, new Object[0]);
                if ((ignoredValue != null || value == null) && (ignoredValue == null || ignoredValue.equals(value))) continue;
                return value;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return null;
    }

    static Object getAnnotationValue(String name, Annotation[] anns, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (annotation == null) continue;
            try {
                for (Annotation ann : anns) {
                    if (!annotation.isInstance(ann)) continue;
                    Method method = ann.getClass().getMethod(name, new Class[0]);
                    return method.invoke((Object)ann, new Object[0]);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return null;
    }

    static Object getAnnotationValue(String name, Method method, int index, Object ignoredValue, Class<? extends Annotation> ... annotations) {
        if (method.getParameterAnnotations() == null || method.getParameterAnnotations().length <= index || method.getParameterAnnotations()[index] == null) {
            return null;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            if (annotation == null) continue;
            try {
                Annotation ann = AnnotationReader.getAnnotation(method, index, annotation);
                if (ann == null) continue;
                Object value = ann.getClass().getMethod(name, new Class[0]).invoke((Object)ann, new Object[0]);
                if ((ignoredValue != null || value == null) && (ignoredValue == null || ignoredValue.equals(value))) continue;
                return value;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private static Annotation getAnnotation(Method method, int index, Class<? extends Annotation> type) {
        Annotation[] annotations;
        if (method.getParameterAnnotations() == null || method.getParameterAnnotations().length <= index || method.getParameterAnnotations()[index] == null) {
            return null;
        }
        for (Annotation annotation : annotations = method.getParameterAnnotations()[index]) {
            if (!type.isInstance(annotation)) continue;
            return annotation;
        }
        return null;
    }

    private static Class<? extends Annotation> load(String name) {
        try {
            return AnnotationReader.class.getClassLoader().loadClass(name).asSubclass(Annotation.class);
        }
        catch (Throwable e) {
            LOG.log(Level.FINE, "Error loading annotation class " + name + ".", e);
            return null;
        }
    }

    public boolean isFlat(Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (!(a instanceof XmlFlattenedArray)) continue;
                return true;
            }
        }
        return false;
    }
}

