/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.formats.avro.AvroDeserializationSchema;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class AvroDeserializationSchemaTest {
    private static final Address address = TestDataGenerator.generateRandomAddress(new Random());

    @Test
    public void testGenericRecord() throws Exception {
        AvroDeserializationSchema deserializationSchema = AvroDeserializationSchema.forGeneric((Schema)address.getSchema());
        byte[] encodedAddress = AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema());
        GenericRecord genericRecord = (GenericRecord)deserializationSchema.deserialize(encodedAddress);
        Assert.assertEquals((Object)address.getCity(), (Object)genericRecord.get("city").toString());
        Assert.assertEquals((Object)address.getNum(), (Object)genericRecord.get("num"));
        Assert.assertEquals((Object)address.getState(), (Object)genericRecord.get("state").toString());
    }

    @Test
    public void testSpecificRecordWithConfluentSchemaRegistry() throws Exception {
        AvroDeserializationSchema deserializer = AvroDeserializationSchema.forSpecific(Address.class);
        byte[] encodedAddress = AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema());
        Address deserializedAddress = (Address)((Object)deserializer.deserialize(encodedAddress));
        Assert.assertEquals((Object)((Object)address), (Object)((Object)deserializedAddress));
    }
}

