/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.util.Collections;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.JobExecutor;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.test.util.TestEnvironment;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class AvroExternalJarProgramITCase
extends TestLogger {
    private static final String JAR_FILE = "maven-test-jar.jar";
    private static final String TEST_DATA_FILE = "/testdata.avro";
    private static final int PARALLELISM = 4;
    private static final MiniCluster MINI_CLUSTER = new MiniCluster(new MiniClusterConfiguration.Builder().setNumTaskManagers(1).setNumSlotsPerTaskManager(4).build());

    @BeforeClass
    public static void setUp() throws Exception {
        MINI_CLUSTER.start();
    }

    @AfterClass
    public static void tearDown() {
        TestEnvironment.unsetAsContext();
        MINI_CLUSTER.closeAsync();
    }

    @Test
    public void testExternalProgram() throws Exception {
        TestEnvironment.setAsContext((JobExecutor)MINI_CLUSTER, (int)4, Collections.singleton(new Path(JAR_FILE)), Collections.emptyList());
        String testData = ((Object)((Object)this)).getClass().getResource(TEST_DATA_FILE).toString();
        PackagedProgram program = new PackagedProgram(new File(JAR_FILE), new String[]{testData});
        program.invokeInteractiveModeForExecution();
    }
}

