/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import com.esotericsoftware.kryo.Kryo;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.testutils.FilteredClassLoader;
import org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.junit.Assert;
import org.junit.Test;

public class AvroKryoClassloadingTest {
    @Test
    public void testKryoInChildClasspath() throws Exception {
        Class<AvroKryoSerializerUtils> avroClass = AvroKryoSerializerUtils.class;
        URL avroLocation = avroClass.getProtectionDomain().getCodeSource().getLocation();
        URL kryoLocation = Kryo.class.getProtectionDomain().getCodeSource().getLocation();
        FilteredClassLoader parentClassLoader = new FilteredClassLoader(avroClass.getClassLoader(), new String[]{AvroKryoSerializerUtils.class.getName()});
        URLClassLoader userAppClassLoader = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{avroLocation, kryoLocation}, (ClassLoader)parentClassLoader, (String[])((String)CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS.defaultValue()).split(";"));
        Class<?> userLoadedAvroClass = Class.forName(avroClass.getName(), false, userAppClassLoader);
        Assert.assertNotEquals(avroClass, userLoadedAvroClass);
        Method m = userLoadedAvroClass.getMethod("addAvroGenericDataArrayRegistration", LinkedHashMap.class);
        LinkedHashMap map = new LinkedHashMap();
        m.invoke(userLoadedAvroClass.newInstance(), map);
        Assert.assertEquals((long)1L, (long)map.size());
    }
}

