/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.formats.avro.AvroOutputFormat;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.test.util.JavaProgramTestBase;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.Assert;

public class AvroOutputFormatITCase
extends JavaProgramTestBase {
    public static String outputPath1;
    public static String outputPath2;
    public static String inputPath;
    public static String userData;

    protected void preSubmit() throws Exception {
        inputPath = this.createTempFile("user", userData);
        outputPath1 = this.getTempDirPath("avro_output1");
        outputPath2 = this.getTempDirPath("avro_output2");
    }

    protected void testProgram() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.readCsvFile(inputPath).fieldDelimiter("|").types(String.class, Integer.class, String.class);
        MapOperator specificUser = input.map((MapFunction)new ConvertToUser());
        AvroOutputFormat avroOutputFormat = new AvroOutputFormat(User.class);
        avroOutputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        avroOutputFormat.setSchema(User.SCHEMA$);
        specificUser.write((FileOutputFormat)avroOutputFormat, outputPath1);
        MapOperator reflectiveUser = specificUser.map((MapFunction)new ConvertToReflective());
        reflectiveUser.write((FileOutputFormat)new AvroOutputFormat(ReflectiveUser.class), outputPath2);
        env.execute();
    }

    protected void postSubmit() throws Exception {
        File[] output1;
        File file1 = AvroOutputFormatITCase.asFile((String)outputPath1);
        if (file1.isDirectory()) {
            output1 = file1.listFiles();
            for (File avroOutput : Objects.requireNonNull(output1)) {
                Assert.assertTrue((String)"Expect extension '.avro'", (boolean)avroOutput.toString().endsWith(".avro"));
            }
        } else {
            output1 = new File[]{file1};
        }
        ArrayList<String> result1 = new ArrayList<String>();
        SpecificDatumReader userDatumReader1 = new SpecificDatumReader(User.class);
        for (File avroOutput : output1) {
            DataFileReader dataFileReader1 = new DataFileReader(avroOutput, (DatumReader)userDatumReader1);
            while (dataFileReader1.hasNext()) {
                User user = (User)((Object)dataFileReader1.next());
                result1.add(user.getName() + "|" + user.getFavoriteNumber() + "|" + user.getFavoriteColor());
            }
        }
        for (String expectedResult : userData.split("\n")) {
            Assert.assertTrue((String)("expected user " + (String)expectedResult + " not found."), (boolean)result1.contains(expectedResult));
        }
        File file2 = AvroOutputFormatITCase.asFile((String)outputPath2);
        File[] output2 = file2.isDirectory() ? file2.listFiles() : new File[]{file2};
        ArrayList<String> result2 = new ArrayList<String>();
        ReflectDatumReader userDatumReader2 = new ReflectDatumReader(ReflectiveUser.class);
        for (File avroOutput : Objects.requireNonNull(output2)) {
            DataFileReader dataFileReader2 = new DataFileReader(avroOutput, (DatumReader)userDatumReader2);
            while (dataFileReader2.hasNext()) {
                ReflectiveUser user = (ReflectiveUser)dataFileReader2.next();
                result2.add(user.getName() + "|" + user.getFavoriteNumber() + "|" + user.getFavoriteColor());
            }
        }
        for (String expectedResult : userData.split("\n")) {
            Assert.assertTrue((String)("expected user " + (String)expectedResult + " not found."), (boolean)result2.contains(expectedResult));
        }
    }

    static {
        userData = "alice|1|blue\nbob|2|red\njohn|3|yellow\nwalt|4|black\n";
    }

    private static class ReflectiveUser {
        private String name;
        private int favoriteNumber;
        private String favoriteColor;

        public ReflectiveUser() {
        }

        public ReflectiveUser(String name, int favoriteNumber, String favoriteColor) {
            this.name = name;
            this.favoriteNumber = favoriteNumber;
            this.favoriteColor = favoriteColor;
        }

        public String getName() {
            return this.name;
        }

        public String getFavoriteColor() {
            return this.favoriteColor;
        }

        public int getFavoriteNumber() {
            return this.favoriteNumber;
        }
    }

    private static final class ConvertToReflective
    extends RichMapFunction<User, ReflectiveUser> {
        private ConvertToReflective() {
        }

        public ReflectiveUser map(User value) {
            return new ReflectiveUser(value.getName().toString(), value.getFavoriteNumber(), value.getFavoriteColor().toString());
        }
    }

    private static final class ConvertToUser
    extends RichMapFunction<Tuple3<String, Integer, String>, User> {
        private ConvertToUser() {
        }

        public User map(Tuple3<String, Integer, String> value) {
            User user = new User();
            user.setName((CharSequence)value.f0);
            user.setFavoriteNumber((Integer)value.f1);
            user.setFavoriteColor((CharSequence)value.f2);
            user.setTypeBoolTest(true);
            user.setTypeArrayString(Collections.emptyList());
            user.setTypeArrayBoolean(Collections.emptyList());
            user.setTypeEnum(Colors.BLUE);
            user.setTypeMap(Collections.emptyMap());
            user.setTypeBytes(ByteBuffer.allocate(10));
            user.setTypeDate(LocalDate.parse((String)"2014-03-01"));
            user.setTypeTimeMillis(LocalTime.parse((String)"12:12:12"));
            user.setTypeTimeMicros(123456);
            user.setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z"));
            user.setTypeTimestampMicros(123456L);
            user.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            user.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            return user;
        }
    }
}

