/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroOutputFormat;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class AvroOutputFormatTest {
    @Test
    public void testSetCodec() {
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        try {
            outputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        }
        catch (Exception ex) {
            Assert.fail((String)"unexpected exception");
        }
    }

    @Test
    public void testSetCodecError() {
        boolean error = false;
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        try {
            outputFormat.setCodec(null);
        }
        catch (Exception ex) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testSerialization() throws Exception {
        this.serializeAndDeserialize(null, null);
        this.serializeAndDeserialize(null, User.SCHEMA$);
        for (AvroOutputFormat.Codec codec : AvroOutputFormat.Codec.values()) {
            this.serializeAndDeserialize(codec, null);
            this.serializeAndDeserialize(codec, User.SCHEMA$);
        }
    }

    private void serializeAndDeserialize(AvroOutputFormat.Codec codec, Schema schema) throws IOException, ClassNotFoundException {
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        if (codec != null) {
            outputFormat.setCodec(codec);
        }
        if (schema != null) {
            outputFormat.setSchema(schema);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(outputFormat);
        }
        var6_6 = null;
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
            Object o = ois.readObject();
            Assert.assertTrue((boolean)(o instanceof AvroOutputFormat));
            AvroOutputFormat restored = (AvroOutputFormat)o;
            AvroOutputFormat.Codec restoredCodec = (AvroOutputFormat.Codec)Whitebox.getInternalState((Object)restored, (String)"codec");
            Schema restoredSchema = (Schema)Whitebox.getInternalState((Object)restored, (String)"userDefinedSchema");
            Assert.assertTrue((boolean)(codec != null ? restoredCodec == codec : restoredCodec == null));
            Assert.assertTrue((boolean)(schema != null ? restoredSchema.equals((Object)schema) : restoredSchema == null));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCompression() throws Exception {
        Path outputPath = new Path(File.createTempFile("avro-output-file", "avro").getAbsolutePath());
        AvroOutputFormat outputFormat = new AvroOutputFormat(outputPath, User.class);
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        Path compressedOutputPath = new Path(File.createTempFile("avro-output-file", "compressed.avro").getAbsolutePath());
        AvroOutputFormat compressedOutputFormat = new AvroOutputFormat(compressedOutputPath, User.class);
        compressedOutputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        compressedOutputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        this.output((AvroOutputFormat<User>)outputFormat);
        this.output((AvroOutputFormat<User>)compressedOutputFormat);
        Assert.assertTrue((this.fileSize(outputPath) > this.fileSize(compressedOutputPath) ? 1 : 0) != 0);
        FileSystem fs = FileSystem.getLocalFileSystem();
        fs.delete(outputPath, false);
        fs.delete(compressedOutputPath, false);
    }

    private long fileSize(Path path) throws IOException {
        return path.getFileSystem().getFileStatus(path).getLen();
    }

    private void output(AvroOutputFormat<User> outputFormat) throws IOException {
        outputFormat.configure(new Configuration());
        outputFormat.open(1, 1);
        for (int i = 0; i < 100; ++i) {
            User user = new User();
            user.setName("testUser");
            user.setFavoriteNumber(1);
            user.setFavoriteColor("blue");
            user.setTypeBoolTest(true);
            user.setTypeArrayString(Collections.emptyList());
            user.setTypeArrayBoolean(Collections.emptyList());
            user.setTypeEnum(Colors.BLUE);
            user.setTypeMap(Collections.emptyMap());
            user.setTypeBytes(ByteBuffer.allocate(10));
            user.setTypeDate(LocalDate.parse((String)"2014-03-01"));
            user.setTypeTimeMillis(LocalTime.parse((String)"12:12:12"));
            user.setTypeTimeMicros(123456);
            user.setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z"));
            user.setTypeTimestampMicros(123456L);
            user.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            user.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            outputFormat.writeRecord((Object)user);
        }
        outputFormat.close();
    }

    @Test
    public void testGenericRecord() throws IOException {
        Path outputPath = new Path(File.createTempFile("avro-output-file", "generic.avro").getAbsolutePath());
        AvroOutputFormat outputFormat = new AvroOutputFormat(outputPath, GenericRecord.class);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\", \"name\":\"user\", \"fields\": [{\"name\":\"user_name\", \"type\":\"string\"}, {\"name\":\"favorite_number\", \"type\":\"int\"}, {\"name\":\"favorite_color\", \"type\":\"string\"}]}");
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        outputFormat.setSchema(schema);
        this.output((AvroOutputFormat<GenericRecord>)outputFormat, schema);
        GenericDatumReader reader = new GenericDatumReader(schema);
        DataFileReader dataFileReader = new DataFileReader(new File(outputPath.getPath()), (DatumReader)reader);
        while (dataFileReader.hasNext()) {
            GenericRecord record = (GenericRecord)dataFileReader.next();
            Assert.assertEquals((Object)record.get("user_name").toString(), (Object)"testUser");
            Assert.assertEquals((Object)record.get("favorite_number"), (Object)1);
            Assert.assertEquals((Object)record.get("favorite_color").toString(), (Object)"blue");
        }
        FileSystem fs = FileSystem.getLocalFileSystem();
        fs.delete(outputPath, false);
    }

    private void output(AvroOutputFormat<GenericRecord> outputFormat, Schema schema) throws IOException {
        outputFormat.configure(new Configuration());
        outputFormat.open(1, 1);
        for (int i = 0; i < 100; ++i) {
            GenericData.Record record = new GenericData.Record(schema);
            record.put("user_name", (Object)"testUser");
            record.put("favorite_number", (Object)1);
            record.put("favorite_color", (Object)"blue");
            outputFormat.writeRecord((Object)record);
        }
        outputFormat.close();
    }
}

