/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.formats.avro.AvroInputFormat;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvroRecordInputFormatTest {
    public File testFile;
    static final String TEST_NAME = "Alyssa";
    static final String TEST_ARRAY_STRING_1 = "ELEMENT 1";
    static final String TEST_ARRAY_STRING_2 = "ELEMENT 2";
    static final boolean TEST_ARRAY_BOOLEAN_1 = true;
    static final boolean TEST_ARRAY_BOOLEAN_2 = false;
    static final Colors TEST_ENUM_COLOR = Colors.GREEN;
    static final String TEST_MAP_KEY1 = "KEY 1";
    static final long TEST_MAP_VALUE1 = 8546456L;
    static final String TEST_MAP_KEY2 = "KEY 2";
    static final long TEST_MAP_VALUE2 = 17554L;
    static final int TEST_NUM = 239;
    static final String TEST_STREET = "Baker Street";
    static final String TEST_CITY = "London";
    static final String TEST_STATE = "London";
    static final String TEST_ZIP = "NW1 6XE";
    private Schema userSchema = new User().getSchema();

    public static void writeTestFile(File testFile) throws IOException {
        ArrayList<CharSequence> stringArray = new ArrayList<CharSequence>();
        stringArray.add(TEST_ARRAY_STRING_1);
        stringArray.add(TEST_ARRAY_STRING_2);
        ArrayList<Boolean> booleanArray = new ArrayList<Boolean>();
        booleanArray.add(true);
        booleanArray.add(false);
        HashMap<CharSequence, Long> longMap = new HashMap<CharSequence, Long>();
        longMap.put(TEST_MAP_KEY1, 8546456L);
        longMap.put(TEST_MAP_KEY2, 17554L);
        Address addr = new Address();
        addr.setNum(239);
        addr.setStreet(TEST_STREET);
        addr.setCity("London");
        addr.setState("London");
        addr.setZip(TEST_ZIP);
        User user1 = new User();
        user1.setName(TEST_NAME);
        user1.setFavoriteNumber(256);
        user1.setTypeDoubleTest(123.45);
        user1.setTypeBoolTest(true);
        user1.setTypeArrayString(stringArray);
        user1.setTypeArrayBoolean(booleanArray);
        user1.setTypeEnum(TEST_ENUM_COLOR);
        user1.setTypeMap(longMap);
        user1.setTypeNested(addr);
        user1.setTypeBytes(ByteBuffer.allocate(10));
        user1.setTypeDate(LocalDate.parse((String)"2014-03-01"));
        user1.setTypeTimeMillis(LocalTime.parse((String)"12:12:12"));
        user1.setTypeTimeMicros(123456);
        user1.setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z"));
        user1.setTypeTimestampMicros(123456L);
        user1.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        user1.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        User user2 = User.newBuilder().setName("Charlie").setFavoriteColor("blue").setFavoriteNumber(null).setTypeBoolTest(false).setTypeDoubleTest(1.337).setTypeNullTest(null).setTypeLongTest(1337L).setTypeArrayString(new ArrayList<CharSequence>()).setTypeArrayBoolean(new ArrayList<Boolean>()).setTypeNullableArray(null).setTypeEnum(Colors.RED).setTypeMap(new HashMap<CharSequence, Long>()).setTypeFixed(null).setTypeUnion(null).setTypeNested(Address.newBuilder().setNum(239).setStreet(TEST_STREET).setCity("London").setState("London").setZip(TEST_ZIP).build()).setTypeBytes(ByteBuffer.allocate(10)).setTypeDate(LocalDate.parse((String)"2014-03-01")).setTypeTimeMillis(LocalTime.parse((String)"12:12:12")).setTypeTimeMicros(123456).setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z")).setTypeTimestampMicros(123456L).setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).build();
        SpecificDatumWriter userDatumWriter = new SpecificDatumWriter(User.class);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)userDatumWriter);
        dataFileWriter.create(user1.getSchema(), testFile);
        dataFileWriter.append((Object)user1);
        dataFileWriter.append((Object)user2);
        dataFileWriter.close();
    }

    @Before
    public void createFiles() throws IOException {
        this.testFile = File.createTempFile("AvroInputFormatTest", null);
        AvroRecordInputFormatTest.writeTestFile(this.testFile);
    }

    @Test
    public void testDeserialization() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.configure(parameters);
        FileInputSplit[] splits = format.createInputSplits(1);
        Assert.assertEquals((long)splits.length, (long)1L);
        format.open(splits[0]);
        User u = (User)((Object)format.nextRecord(null));
        Assert.assertNotNull((Object)((Object)u));
        String name = u.getName().toString();
        Assert.assertNotNull((String)"empty record", (Object)name);
        Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)name);
        List<CharSequence> sl = u.getTypeArrayString();
        Assert.assertEquals((String)"element 0 not equal", (Object)TEST_ARRAY_STRING_1, (Object)sl.get(0).toString());
        Assert.assertEquals((String)"element 1 not equal", (Object)TEST_ARRAY_STRING_2, (Object)sl.get(1).toString());
        List<Boolean> bl = u.getTypeArrayBoolean();
        Assert.assertEquals((String)"element 0 not equal", (Object)true, (Object)bl.get(0));
        Assert.assertEquals((String)"element 1 not equal", (Object)false, (Object)bl.get(1));
        Colors enumValue = u.getTypeEnum();
        Assert.assertEquals((String)"enum not equal", (Object)((Object)TEST_ENUM_COLOR), (Object)((Object)enumValue));
        Map<CharSequence, Long> lm = u.getTypeMap();
        Assert.assertEquals((String)"map value of key 1 not equal", (long)8546456L, (long)lm.get(new Utf8(TEST_MAP_KEY1)));
        Assert.assertEquals((String)"map value of key 2 not equal", (long)17554L, (long)lm.get(new Utf8(TEST_MAP_KEY2)));
        Assert.assertFalse((String)"expecting second element", (boolean)format.reachedEnd());
        Assert.assertNotNull((String)"expecting second element", (Object)format.nextRecord((Object)u));
        Assert.assertNull((Object)format.nextRecord((Object)u));
        Assert.assertTrue((boolean)format.reachedEnd());
        format.close();
    }

    @Test
    public void testDeserializationReuseAvroRecordFalse() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.setReuseAvroValue(false);
        format.configure(parameters);
        FileInputSplit[] splits = format.createInputSplits(1);
        Assert.assertEquals((long)splits.length, (long)1L);
        format.open(splits[0]);
        User u = (User)((Object)format.nextRecord(null));
        Assert.assertNotNull((Object)((Object)u));
        String name = u.getName().toString();
        Assert.assertNotNull((String)"empty record", (Object)name);
        Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)name);
        List<CharSequence> sl = u.getTypeArrayString();
        Assert.assertEquals((String)"element 0 not equal", (Object)TEST_ARRAY_STRING_1, (Object)sl.get(0).toString());
        Assert.assertEquals((String)"element 1 not equal", (Object)TEST_ARRAY_STRING_2, (Object)sl.get(1).toString());
        List<Boolean> bl = u.getTypeArrayBoolean();
        Assert.assertEquals((String)"element 0 not equal", (Object)true, (Object)bl.get(0));
        Assert.assertEquals((String)"element 1 not equal", (Object)false, (Object)bl.get(1));
        Colors enumValue = u.getTypeEnum();
        Assert.assertEquals((String)"enum not equal", (Object)((Object)TEST_ENUM_COLOR), (Object)((Object)enumValue));
        Map<CharSequence, Long> lm = u.getTypeMap();
        Assert.assertEquals((String)"map value of key 1 not equal", (long)8546456L, (long)lm.get(new Utf8(TEST_MAP_KEY1)));
        Assert.assertEquals((String)"map value of key 2 not equal", (long)17554L, (long)lm.get(new Utf8(TEST_MAP_KEY2)));
        Assert.assertFalse((String)"expecting second element", (boolean)format.reachedEnd());
        Assert.assertNotNull((String)"expecting second element", (Object)format.nextRecord((Object)u));
        Assert.assertNull((Object)format.nextRecord((Object)u));
        Assert.assertTrue((boolean)format.reachedEnd());
        format.close();
    }

    @Test
    public void testDeserializeToGenericType() throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader(this.userSchema);
        try (FileReader dataFileReader = DataFileReader.openReader((File)this.testFile, (DatumReader)datumReader);){
            GenericData.Record newRec;
            GenericData.Record rec = new GenericData.Record(this.userSchema);
            dataFileReader.next((Object)rec);
            Assert.assertNotNull((Object)rec);
            Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)rec.get("name").toString());
            Assert.assertEquals((String)"enum not equal", (Object)TEST_ENUM_COLOR.toString(), (Object)rec.get("type_enum").toString());
            Assert.assertEquals(null, (Object)rec.get("type_long_test"));
            TypeInformation te = TypeExtractor.createTypeInfo(GenericData.Record.class);
            ExecutionConfig ec = new ExecutionConfig();
            Assert.assertEquals(GenericTypeInfo.class, te.getClass());
            Serializers.recursivelyRegisterType((Class)te.getTypeClass(), (ExecutionConfig)ec, new HashSet());
            TypeSerializer tser = te.createSerializer(ec);
            Assert.assertEquals((long)1L, (long)ec.getDefaultKryoSerializerClasses().size());
            Assert.assertTrue((ec.getDefaultKryoSerializerClasses().containsKey(Schema.class) && ((Class)ec.getDefaultKryoSerializerClasses().get(Schema.class)).equals(AvroKryoSerializerUtils.AvroSchemaSerializer.class) ? 1 : 0) != 0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper((OutputStream)out);){
                tser.serialize((Object)rec, (DataOutputView)outView);
            }
            try (DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                newRec = (GenericData.Record)tser.deserialize((DataInputView)inView);
            }
            Assert.assertNotNull((Object)newRec);
            Assert.assertEquals((String)"enum not equal", (Object)TEST_ENUM_COLOR.toString(), (Object)newRec.get("type_enum").toString());
            Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)newRec.get("name").toString());
            Assert.assertEquals(null, (Object)newRec.get("type_long_test"));
        }
    }

    @Test
    public void testDeserializeToSpecificType() throws IOException {
        SpecificDatumReader datumReader = new SpecificDatumReader(this.userSchema);
        try (FileReader dataFileReader = DataFileReader.openReader((File)this.testFile, (DatumReader)datumReader);){
            User newRec;
            User rec = (User)((Object)dataFileReader.next());
            Assert.assertNotNull((Object)((Object)rec));
            Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)rec.get("name").toString());
            Assert.assertEquals((String)"enum not equal", (Object)TEST_ENUM_COLOR.toString(), (Object)rec.get("type_enum").toString());
            ExecutionConfig ec = new ExecutionConfig();
            TypeInformation te = TypeExtractor.createTypeInfo(User.class);
            Assert.assertEquals(AvroTypeInfo.class, te.getClass());
            TypeSerializer tser = te.createSerializer(ec);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper((OutputStream)out);){
                tser.serialize((Object)rec, (DataOutputView)outView);
            }
            try (DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                newRec = (User)((Object)tser.deserialize((DataInputView)inView));
            }
            Assert.assertNotNull((Object)((Object)newRec));
            Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)newRec.getName().toString());
            Assert.assertEquals((String)"enum not equal", (Object)TEST_ENUM_COLOR.toString(), (Object)newRec.getTypeEnum().toString());
        }
    }

    @Test
    public void testDeserializationGenericRecord() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), GenericRecord.class);
        this.doTestDeserializationGenericRecord((AvroInputFormat<GenericRecord>)format, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestDeserializationGenericRecord(AvroInputFormat<GenericRecord> format, Configuration parameters) throws IOException {
        try {
            format.configure(parameters);
            FileInputSplit[] splits = format.createInputSplits(1);
            Assert.assertEquals((long)splits.length, (long)1L);
            format.open(splits[0]);
            GenericRecord u = (GenericRecord)format.nextRecord(null);
            Assert.assertNotNull((Object)u);
            Assert.assertEquals((String)"The schemas should be equal", (Object)this.userSchema, (Object)u.getSchema());
            String name = u.get("name").toString();
            Assert.assertNotNull((String)"empty record", (Object)name);
            Assert.assertEquals((String)"name not equal", (Object)TEST_NAME, (Object)name);
            List sl = (List)u.get("type_array_string");
            Assert.assertEquals((String)"element 0 not equal", (Object)TEST_ARRAY_STRING_1, (Object)((CharSequence)sl.get(0)).toString());
            Assert.assertEquals((String)"element 1 not equal", (Object)TEST_ARRAY_STRING_2, (Object)((CharSequence)sl.get(1)).toString());
            List bl = (List)u.get("type_array_boolean");
            Assert.assertEquals((String)"element 0 not equal", (Object)true, bl.get(0));
            Assert.assertEquals((String)"element 1 not equal", (Object)false, bl.get(1));
            GenericData.EnumSymbol enumValue = (GenericData.EnumSymbol)u.get("type_enum");
            Assert.assertEquals((String)"enum not equal", (Object)TEST_ENUM_COLOR.toString(), (Object)enumValue.toString());
            Map lm = (Map)u.get("type_map");
            Assert.assertEquals((String)"map value of key 1 not equal", (long)8546456L, (long)((Long)lm.get(new Utf8(TEST_MAP_KEY1))));
            Assert.assertEquals((String)"map value of key 2 not equal", (long)17554L, (long)((Long)lm.get(new Utf8(TEST_MAP_KEY2))));
            Assert.assertFalse((String)"expecting second element", (boolean)format.reachedEnd());
            Assert.assertNotNull((String)"expecting second element", (Object)format.nextRecord((Object)u));
            Assert.assertNull((Object)format.nextRecord((Object)u));
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        finally {
            format.close();
        }
    }

    @Test
    public void testDeserializationGenericRecordReuseAvroValueFalse() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), GenericRecord.class);
        format.configure(parameters);
        format.setReuseAvroValue(false);
        this.doTestDeserializationGenericRecord((AvroInputFormat<GenericRecord>)format, parameters);
    }

    @After
    public void deleteFiles() {
        this.testFile.delete();
    }
}

