/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.formats.avro.AvroRowDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowSerializationSchema;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class AvroRowDeSerializationSchemaTest {
    @Test
    public void testSpecificSerializeDeserializeFromClass() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testSpecificSerializeDeserializeFromSchema() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testGenericSerializeDeserialize() throws IOException {
        Tuple3<GenericRecord, Row, Schema> testData = AvroTestUtils.getGenericTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(((Schema)testData.f2).toString());
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(((Schema)testData.f2).toString());
        byte[] bytes = serializationSchema.serialize((Row)testData.f1);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f1, (Object)actual);
    }

    @Test
    public void testSpecificSerializeFromClassSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        serializationSchema.serialize((Row)testData.f2);
        serializationSchema.serialize((Row)testData.f2);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testSpecificSerializeFromSchemaSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        serializationSchema.serialize((Row)testData.f2);
        serializationSchema.serialize((Row)testData.f2);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testGenericSerializeSeveralTimes() throws IOException {
        Tuple3<GenericRecord, Row, Schema> testData = AvroTestUtils.getGenericTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(((Schema)testData.f2).toString());
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(((Schema)testData.f2).toString());
        serializationSchema.serialize((Row)testData.f1);
        serializationSchema.serialize((Row)testData.f1);
        byte[] bytes = serializationSchema.serialize((Row)testData.f1);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f1, (Object)actual);
    }

    @Test
    public void testSpecificDeserializeFromClassSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema((Class)testData.f0);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        deserializationSchema.deserialize(bytes);
        deserializationSchema.deserialize(bytes);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testSpecificDeserializeFromSchemaSeveralTimes() throws IOException {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(schemaString);
        byte[] bytes = serializationSchema.serialize((Row)testData.f2);
        deserializationSchema.deserialize(bytes);
        deserializationSchema.deserialize(bytes);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f2, (Object)actual);
    }

    @Test
    public void testGenericDeserializeSeveralTimes() throws IOException {
        Tuple3<GenericRecord, Row, Schema> testData = AvroTestUtils.getGenericTestData();
        AvroRowSerializationSchema serializationSchema = new AvroRowSerializationSchema(((Schema)testData.f2).toString());
        AvroRowDeserializationSchema deserializationSchema = new AvroRowDeserializationSchema(((Schema)testData.f2).toString());
        byte[] bytes = serializationSchema.serialize((Row)testData.f1);
        deserializationSchema.deserialize(bytes);
        deserializationSchema.deserialize(bytes);
        Row actual = deserializationSchema.deserialize(bytes);
        Assert.assertEquals((Object)testData.f1, (Object)actual);
    }

    @Test
    public void testSerializability() throws Exception {
        Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> testData = AvroTestUtils.getSpecificTestData();
        String schemaString = ((SpecificRecord)testData.f1).getSchema().toString();
        AvroRowSerializationSchema classSer = new AvroRowSerializationSchema((Class)testData.f0);
        AvroRowDeserializationSchema classDeser = new AvroRowDeserializationSchema((Class)testData.f0);
        this.testSerializability(classSer, classDeser, (Row)testData.f2);
        AvroRowSerializationSchema schemaSer = new AvroRowSerializationSchema(schemaString);
        AvroRowDeserializationSchema schemaDeser = new AvroRowDeserializationSchema(schemaString);
        this.testSerializability(schemaSer, schemaDeser, (Row)testData.f2);
    }

    private void testSerializability(AvroRowSerializationSchema ser, AvroRowDeserializationSchema deser, Row data) throws Exception {
        byte[] serBytes = InstantiationUtil.serializeObject((Object)ser);
        byte[] deserBytes = InstantiationUtil.serializeObject((Object)deser);
        AvroRowSerializationSchema serCopy = (AvroRowSerializationSchema)InstantiationUtil.deserializeObject((byte[])serBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        AvroRowDeserializationSchema deserCopy = (AvroRowDeserializationSchema)InstantiationUtil.deserializeObject((byte[])deserBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        byte[] bytes = serCopy.serialize(data);
        deserCopy.deserialize(bytes);
        deserCopy.deserialize(bytes);
        Row actual = deserCopy.deserialize(bytes);
        Assert.assertEquals((Object)data, (Object)actual);
    }
}

