/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.util.Map;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.AvroRowDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowSerializationSchema;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.table.descriptors.Avro;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class AvroRowFormatFactoryTest
extends TestLogger {
    private static final Class<User> AVRO_SPECIFIC_RECORD = User.class;
    private static final String AVRO_SCHEMA = User.getClassSchema().toString();

    @Test
    public void testRecordClass() {
        Map<String, String> properties = AvroRowFormatFactoryTest.toMap(new Descriptor[]{new Avro().recordClass(AVRO_SPECIFIC_RECORD)});
        this.testRecordClassDeserializationSchema(properties);
        this.testRecordClassSerializationSchema(properties);
    }

    @Test
    public void testAvroSchema() {
        Map<String, String> properties = AvroRowFormatFactoryTest.toMap(new Descriptor[]{new Avro().avroSchema(AVRO_SCHEMA)});
        this.testAvroSchemaSerializationSchema(properties);
        this.testAvroSchemaDeserializationSchema(properties);
    }

    private void testRecordClassSerializationSchema(Map<String, String> properties) {
        DeserializationSchema actual2 = ((DeserializationSchemaFactory)TableFactoryService.find(DeserializationSchemaFactory.class, properties)).createDeserializationSchema(properties);
        AvroRowDeserializationSchema expected2 = new AvroRowDeserializationSchema(AVRO_SPECIFIC_RECORD);
        Assert.assertEquals((Object)expected2, (Object)actual2);
    }

    private void testRecordClassDeserializationSchema(Map<String, String> properties) {
        SerializationSchema actual1 = ((SerializationSchemaFactory)TableFactoryService.find(SerializationSchemaFactory.class, properties)).createSerializationSchema(properties);
        AvroRowSerializationSchema expected1 = new AvroRowSerializationSchema(AVRO_SPECIFIC_RECORD);
        Assert.assertEquals((Object)expected1, (Object)actual1);
    }

    private void testAvroSchemaDeserializationSchema(Map<String, String> properties) {
        DeserializationSchema actual2 = ((DeserializationSchemaFactory)TableFactoryService.find(DeserializationSchemaFactory.class, properties)).createDeserializationSchema(properties);
        AvroRowDeserializationSchema expected2 = new AvroRowDeserializationSchema(AVRO_SCHEMA);
        Assert.assertEquals((Object)expected2, (Object)actual2);
    }

    private void testAvroSchemaSerializationSchema(Map<String, String> properties) {
        SerializationSchema actual1 = ((SerializationSchemaFactory)TableFactoryService.find(SerializationSchemaFactory.class, properties)).createSerializationSchema(properties);
        AvroRowSerializationSchema expected1 = new AvroRowSerializationSchema(AVRO_SCHEMA);
        Assert.assertEquals((Object)expected1, (Object)actual1);
    }

    private static Map<String, String> toMap(Descriptor ... desc) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        for (Descriptor d : desc) {
            d.addProperties(descriptorProperties);
        }
        return descriptorProperties.asMap();
    }
}

