/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroInputFormat;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed16;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AvroSplittableInputFormatTest {
    private File testFile;
    static final String TEST_NAME = "Alyssa";
    static final String TEST_ARRAY_STRING_1 = "ELEMENT 1";
    static final String TEST_ARRAY_STRING_2 = "ELEMENT 2";
    static final boolean TEST_ARRAY_BOOLEAN_1 = true;
    static final boolean TEST_ARRAY_BOOLEAN_2 = false;
    static final Colors TEST_ENUM_COLOR = Colors.GREEN;
    static final String TEST_MAP_KEY1 = "KEY 1";
    static final long TEST_MAP_VALUE1 = 8546456L;
    static final String TEST_MAP_KEY2 = "KEY 2";
    static final long TEST_MAP_VALUE2 = 17554L;
    static final Integer TEST_NUM = 239;
    static final String TEST_STREET = "Baker Street";
    static final String TEST_CITY = "London";
    static final String TEST_STATE = "London";
    static final String TEST_ZIP = "NW1 6XE";
    static final int NUM_RECORDS = 5000;

    @Before
    public void createFiles() throws IOException {
        this.testFile = File.createTempFile("AvroSplittableInputFormatTest", null);
        ArrayList<CharSequence> stringArray = new ArrayList<CharSequence>();
        stringArray.add(TEST_ARRAY_STRING_1);
        stringArray.add(TEST_ARRAY_STRING_2);
        ArrayList<Boolean> booleanArray = new ArrayList<Boolean>();
        booleanArray.add(true);
        booleanArray.add(false);
        HashMap<CharSequence, Long> longMap = new HashMap<CharSequence, Long>();
        longMap.put(TEST_MAP_KEY1, 8546456L);
        longMap.put(TEST_MAP_KEY2, 17554L);
        Address addr = new Address();
        addr.setNum(TEST_NUM);
        addr.setStreet(TEST_STREET);
        addr.setCity("London");
        addr.setState("London");
        addr.setZip(TEST_ZIP);
        User user1 = new User();
        user1.setName(TEST_NAME);
        user1.setFavoriteNumber(256);
        user1.setTypeDoubleTest(123.45);
        user1.setTypeBoolTest(true);
        user1.setTypeArrayString(stringArray);
        user1.setTypeArrayBoolean(booleanArray);
        user1.setTypeEnum(TEST_ENUM_COLOR);
        user1.setTypeMap(longMap);
        user1.setTypeNested(addr);
        user1.setTypeBytes(ByteBuffer.allocate(10));
        user1.setTypeDate(LocalDate.parse((String)"2014-03-01"));
        user1.setTypeTimeMillis(LocalTime.parse((String)"12:12:12"));
        user1.setTypeTimeMicros(123456);
        user1.setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z"));
        user1.setTypeTimestampMicros(123456L);
        user1.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        user1.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        User user2 = User.newBuilder().setName(TEST_NAME).setFavoriteColor("blue").setFavoriteNumber(null).setTypeBoolTest(false).setTypeDoubleTest(1.337).setTypeNullTest(null).setTypeLongTest(1337L).setTypeArrayString(new ArrayList<CharSequence>()).setTypeArrayBoolean(new ArrayList<Boolean>()).setTypeNullableArray(null).setTypeEnum(Colors.RED).setTypeMap(new HashMap<CharSequence, Long>()).setTypeFixed(new Fixed16()).setTypeUnion(123L).setTypeNested(Address.newBuilder().setNum(TEST_NUM).setStreet(TEST_STREET).setCity("London").setState("London").setZip(TEST_ZIP).build()).setTypeBytes(ByteBuffer.allocate(10)).setTypeDate(LocalDate.parse((String)"2014-03-01")).setTypeTimeMillis(LocalTime.parse((String)"12:12:12")).setTypeTimeMicros(123456).setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z")).setTypeTimestampMicros(123456L).setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).build();
        SpecificDatumWriter userDatumWriter = new SpecificDatumWriter(User.class);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)userDatumWriter);
        dataFileWriter.create(user1.getSchema(), this.testFile);
        dataFileWriter.append((Object)user1);
        dataFileWriter.append((Object)user2);
        Random rnd = new Random(1337L);
        for (int i = 0; i < 4998; ++i) {
            User user = new User();
            user.setName(TEST_NAME + rnd.nextInt());
            user.setFavoriteNumber(rnd.nextInt());
            user.setTypeDoubleTest(rnd.nextDouble());
            user.setTypeBoolTest(true);
            user.setTypeArrayString(stringArray);
            user.setTypeArrayBoolean(booleanArray);
            user.setTypeEnum(TEST_ENUM_COLOR);
            user.setTypeMap(longMap);
            Address address = new Address();
            address.setNum(TEST_NUM);
            address.setStreet(TEST_STREET);
            address.setCity("London");
            address.setState("London");
            address.setZip(TEST_ZIP);
            user.setTypeNested(address);
            user.setTypeBytes(ByteBuffer.allocate(10));
            user.setTypeDate(LocalDate.parse((String)"2014-03-01"));
            user.setTypeTimeMillis(LocalTime.parse((String)"12:12:12"));
            user.setTypeTimeMicros(123456);
            user.setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z"));
            user.setTypeTimestampMicros(123456L);
            user.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            user.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            dataFileWriter.append((Object)user);
        }
        dataFileWriter.close();
    }

    @Test
    public void testSplittedIF() throws IOException {
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.configure(parameters);
        FileInputSplit[] splits = format.createInputSplits(4);
        Assert.assertEquals((long)splits.length, (long)4L);
        int elements = 0;
        int[] elementsPerSplit = new int[4];
        for (int i = 0; i < splits.length; ++i) {
            format.open(splits[i]);
            while (!format.reachedEnd()) {
                User u = (User)((Object)format.nextRecord(null));
                Assert.assertTrue((boolean)u.getName().toString().startsWith(TEST_NAME));
                ++elements;
                int n = i;
                elementsPerSplit[n] = elementsPerSplit[n] + 1;
            }
            format.close();
        }
        Assert.assertEquals((long)1604L, (long)elementsPerSplit[0]);
        Assert.assertEquals((long)1203L, (long)elementsPerSplit[1]);
        Assert.assertEquals((long)1203L, (long)elementsPerSplit[2]);
        Assert.assertEquals((long)990L, (long)elementsPerSplit[3]);
        Assert.assertEquals((long)5000L, (long)elements);
        format.close();
    }

    @Test
    public void testAvroRecoveryWithFailureAtStart() throws Exception {
        int recordsUntilCheckpoint = 132;
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.configure(parameters);
        FileInputSplit[] splits = format.createInputSplits(4);
        Assert.assertEquals((long)splits.length, (long)4L);
        int elements = 0;
        int[] elementsPerSplit = new int[4];
        for (int i = 0; i < splits.length; ++i) {
            format.reopen(splits[i], format.getCurrentState());
            while (!format.reachedEnd()) {
                User u = (User)((Object)format.nextRecord(null));
                Assert.assertTrue((boolean)u.getName().toString().startsWith(TEST_NAME));
                ++elements;
                if (format.getRecordsReadFromBlock() == 132L) {
                    Tuple2 state = format.getCurrentState();
                    format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
                    format.reopen(splits[i], state);
                    Assert.assertEquals((long)format.getRecordsReadFromBlock(), (long)132L);
                }
                int n = i;
                elementsPerSplit[n] = elementsPerSplit[n] + 1;
            }
            format.close();
        }
        Assert.assertEquals((long)1604L, (long)elementsPerSplit[0]);
        Assert.assertEquals((long)1203L, (long)elementsPerSplit[1]);
        Assert.assertEquals((long)1203L, (long)elementsPerSplit[2]);
        Assert.assertEquals((long)990L, (long)elementsPerSplit[3]);
        Assert.assertEquals((long)5000L, (long)elements);
        format.close();
    }

    @Test
    public void testAvroRecovery() throws Exception {
        int recordsUntilCheckpoint = 132;
        Configuration parameters = new Configuration();
        AvroInputFormat format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
        format.configure(parameters);
        FileInputSplit[] splits = format.createInputSplits(4);
        Assert.assertEquals((long)splits.length, (long)4L);
        int elements = 0;
        int[] elementsPerSplit = new int[4];
        for (int i = 0; i < splits.length; ++i) {
            format.open(splits[i]);
            while (!format.reachedEnd()) {
                User u = (User)((Object)format.nextRecord(null));
                Assert.assertTrue((boolean)u.getName().toString().startsWith(TEST_NAME));
                ++elements;
                if (format.getRecordsReadFromBlock() == 132L) {
                    Tuple2 state = format.getCurrentState();
                    format = new AvroInputFormat(new Path(this.testFile.getAbsolutePath()), User.class);
                    format.reopen(splits[i], state);
                    Assert.assertEquals((long)format.getRecordsReadFromBlock(), (long)132L);
                }
                int n = i;
                elementsPerSplit[n] = elementsPerSplit[n] + 1;
            }
            format.close();
        }
        Assert.assertEquals((long)1604L, (long)elementsPerSplit[0]);
        Assert.assertEquals((long)1203L, (long)elementsPerSplit[1]);
        Assert.assertEquals((long)1203L, (long)elementsPerSplit[2]);
        Assert.assertEquals((long)990L, (long)elementsPerSplit[3]);
        Assert.assertEquals((long)5000L, (long)elements);
        format.close();
    }

    @After
    public void deleteFiles() {
        this.testFile.delete();
    }
}

