/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.File;
import java.util.Collections;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.JobExecutor;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.test.util.TestEnvironment;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class LegacyAvroExternalJarProgramITCase
extends TestLogger {
    private static final String JAR_FILE = "maven-test-jar.jar";
    private static final String TEST_DATA_FILE = "/testdata.avro";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalProgram() {
        LocalFlinkMiniCluster testMiniCluster = null;
        try {
            int parallelism = 4;
            Configuration config = new Configuration();
            config.setInteger("taskmanager.numberOfTaskSlots", parallelism);
            testMiniCluster = new LocalFlinkMiniCluster(config, false);
            testMiniCluster.start();
            String jarFile = JAR_FILE;
            String testData = ((Object)((Object)this)).getClass().getResource(TEST_DATA_FILE).toString();
            PackagedProgram program = new PackagedProgram(new File(jarFile), new String[]{testData});
            TestEnvironment.setAsContext((JobExecutor)testMiniCluster, (int)parallelism, Collections.singleton(new Path(jarFile)), Collections.emptyList());
            config.setString(JobManagerOptions.ADDRESS, "localhost");
            config.setInteger(JobManagerOptions.PORT, testMiniCluster.getLeaderRPCPort());
            program.invokeInteractiveModeForExecution();
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)("Error during the packaged program execution: " + t.getMessage()));
        }
        finally {
            TestEnvironment.unsetAsContext();
            if (testMiniCluster != null) {
                try {
                    testMiniCluster.stop();
                }
                catch (Throwable parallelism) {}
            }
        }
    }
}

