/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.flink.formats.avro.RegistryAvroDeserializationSchema;
import org.apache.flink.formats.avro.SchemaCoder;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.SimpleRecord;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class RegistryAvroDeserializationSchemaTest {
    private static final Address address = TestDataGenerator.generateRandomAddress(new Random());

    @Test
    public void testGenericRecordReadWithCompatibleSchema() throws IOException {
        RegistryAvroDeserializationSchema deserializer = new RegistryAvroDeserializationSchema(GenericRecord.class, (Schema)SchemaBuilder.record((String)"Address").fields().requiredString("street").requiredInt("num").optionalString("country").endRecord(), (SchemaCoder.SchemaCoderProvider & Serializable)() -> new SchemaCoder(){

            public Schema readSchema(InputStream in) {
                return Address.getClassSchema();
            }
        });
        GenericRecord genericRecord = (GenericRecord)deserializer.deserialize(AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema()));
        Assert.assertEquals((Object)address.getNum(), (Object)genericRecord.get("num"));
        Assert.assertEquals((Object)address.getStreet(), (Object)genericRecord.get("street").toString());
        Assert.assertNull((Object)genericRecord.get("city"));
        Assert.assertNull((Object)genericRecord.get("state"));
        Assert.assertNull((Object)genericRecord.get("zip"));
        Assert.assertNull((Object)genericRecord.get("country"));
    }

    @Test
    public void testSpecificRecordReadMoreFieldsThanWereWritten() throws IOException {
        Schema smallerUserSchema = new Schema.Parser().parse("{\"namespace\": \"org.apache.flink.formats.avro.generated\",\n \"type\": \"record\",\n \"name\": \"SimpleRecord\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"} ]\n}]");
        RegistryAvroDeserializationSchema deserializer = new RegistryAvroDeserializationSchema(SimpleRecord.class, null, (SchemaCoder.SchemaCoderProvider & Serializable)() -> in -> smallerUserSchema);
        GenericData.Record smallUser = new GenericRecordBuilder(smallerUserSchema).set("name", (Object)"someName").build();
        SimpleRecord simpleRecord = (SimpleRecord)((Object)deserializer.deserialize(AvroTestUtils.writeRecord((GenericRecord)smallUser, smallerUserSchema)));
        Assert.assertEquals((Object)"someName", (Object)simpleRecord.getName().toString());
        Assert.assertNull((Object)simpleRecord.getOptionalField());
    }
}

