/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.junit.Assert;
import org.junit.Test;

public class AvroSchemaConverterTest {
    @Test
    public void testAvroClassConversion() {
        this.validateUserSchema(AvroSchemaConverter.convertToTypeInfo(User.class));
    }

    @Test
    public void testAvroSchemaConversion() {
        String schema = User.getClassSchema().toString(true);
        this.validateUserSchema(AvroSchemaConverter.convertToTypeInfo((String)schema));
    }

    private void validateUserSchema(TypeInformation<?> actual) {
        TypeInformation address = Types.ROW_NAMED((String[])new String[]{"num", "street", "city", "state", "zip"}, (TypeInformation[])new TypeInformation[]{Types.INT, Types.STRING, Types.STRING, Types.STRING, Types.STRING});
        TypeInformation user = Types.ROW_NAMED((String[])new String[]{"name", "favorite_number", "favorite_color", "type_long_test", "type_double_test", "type_null_test", "type_bool_test", "type_array_string", "type_array_boolean", "type_nullable_array", "type_enum", "type_map", "type_fixed", "type_union", "type_nested", "type_bytes", "type_date", "type_time_millis", "type_time_micros", "type_timestamp_millis", "type_timestamp_micros", "type_decimal_bytes", "type_decimal_fixed"}, (TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT, Types.STRING, Types.LONG, Types.DOUBLE, Types.VOID, Types.BOOLEAN, Types.OBJECT_ARRAY((TypeInformation)Types.STRING), Types.OBJECT_ARRAY((TypeInformation)Types.BOOLEAN), Types.OBJECT_ARRAY((TypeInformation)Types.STRING), Types.STRING, Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.LONG), Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), Types.GENERIC(Object.class), address, Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), Types.SQL_DATE, Types.SQL_TIME, Types.INT, Types.SQL_TIMESTAMP, Types.LONG, Types.BIG_DEC, Types.BIG_DEC});
        Assert.assertEquals((Object)user, actual);
        RowTypeInfo userRowInfo = (RowTypeInfo)user;
        Assert.assertTrue((boolean)userRowInfo.schemaEquals(actual));
    }
}

