/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.junit.Assert;
import org.junit.Test;

public class AvroSerializerSerializabilityTest {
    private static final String RESOURCE_NAME = "flink-1.4-serializer-java-serialized";

    @Test
    public void testDeserializeSerializer() throws Exception {
        AvroSerializer currentSerializer = new AvroSerializer(String.class);
        try (ObjectInputStream in = new ObjectInputStream(this.getClass().getClassLoader().getResourceAsStream(RESOURCE_NAME));){
            AvroSerializer deserialized = (AvroSerializer)in.readObject();
            Assert.assertEquals((Object)currentSerializer, (Object)deserialized);
        }
    }

    public static void main(String[] args) throws Exception {
        AvroSerializer serializer = new AvroSerializer(String.class);
        File file = new File("flink-formats/flink-avro/src/test/resources/flink-1.4-serializer-java-serialized").getAbsoluteFile();
        try (FileOutputStream fos = new FileOutputStream(file);
             ObjectOutputStream out = new ObjectOutputStream(fos);){
            out.writeObject(serializer);
        }
    }
}

