/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.formats.avro.generated.SimpleUser;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class BackwardsCompatibleAvroSerializerTest {
    private static final String SNAPSHOT_RESOURCE = "flink-1.6-avro-type-serializer-snapshot";
    private static final String DATA_RESOURCE = "flink-1.6-avro-type-serialized-data";
    private static final String SNAPSHOT_RESOURCE_WRITER = "/data/repositories/flink/flink-formats/flink-avro/src/test/resources/flink-1.6-avro-type-serializer-snapshot";
    private static final String DATA_RESOURCE_WRITER = "/data/repositories/flink/flink-formats/flink-avro/src/test/resources/flink-1.6-avro-type-serialized-data";
    private static final long RANDOM_SEED = 143065108437678L;
    private static final int NUM_DATA_ENTRIES = 20;

    @Test
    public void testCompatibilityWithPojoSerializer() throws Exception {
        TypeSerializerConfigSnapshot configSnapshot;
        TypeSerializer serializer;
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(SNAPSHOT_RESOURCE);){
            TypeSerializer typedSerializer;
            DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper(in);
            List deserialized = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)inView, (ClassLoader)this.getClass().getClassLoader());
            Assert.assertEquals((long)1L, (long)deserialized.size());
            serializer = typedSerializer = (TypeSerializer)((Tuple2)deserialized.get((int)0)).f0;
            configSnapshot = (TypeSerializerConfigSnapshot)((Tuple2)deserialized.get((int)0)).f1;
        }
        Assert.assertNotNull((Object)serializer);
        Assert.assertNotNull((Object)configSnapshot);
        Assert.assertTrue((boolean)(serializer instanceof PojoSerializer));
        Assert.assertTrue((boolean)(configSnapshot instanceof PojoSerializer.PojoSerializerConfigSnapshot));
        BackwardsCompatibleAvroSerializerTest.validateDeserialization((TypeSerializer<SimpleUser>)serializer);
        Assert.assertFalse((boolean)serializer.ensureCompatibility(configSnapshot).isRequiresMigration());
        TypeSerializer newSerializer = new AvroTypeInfo(SimpleUser.class, true).createSerializer(new ExecutionConfig());
        Assert.assertFalse((boolean)newSerializer.ensureCompatibility(configSnapshot).isRequiresMigration());
        BackwardsCompatibleAvroSerializerTest.validateDeserialization((TypeSerializer<SimpleUser>)newSerializer);
        TypeSerializerConfigSnapshot nextSnapshot = newSerializer.snapshotConfiguration();
        TypeSerializer nextSerializer = new AvroTypeInfo(SimpleUser.class, true).createSerializer(new ExecutionConfig());
        Assert.assertFalse((boolean)nextSerializer.ensureCompatibility(nextSnapshot).isRequiresMigration());
        BackwardsCompatibleAvroSerializerTest.validateDeserialization((TypeSerializer<SimpleUser>)nextSerializer);
    }

    private static void validateDeserialization(TypeSerializer<SimpleUser> serializer) throws IOException {
        Random rnd = new Random(143065108437678L);
        try (InputStream in = BackwardsCompatibleAvroSerializerTest.class.getClassLoader().getResourceAsStream(DATA_RESOURCE);){
            DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper(in);
            for (int i = 0; i < 20; ++i) {
                SimpleUser deserialized = (SimpleUser)((Object)serializer.deserialize((DataInputView)inView));
                SimpleUser reference = TestDataGenerator.generateRandomSimpleUser(rnd);
                Assert.assertEquals((Object)((Object)reference), (Object)((Object)deserialized));
            }
        }
    }
}

