/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed16;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.types.Row;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public final class AvroTestUtils {
    public static Tuple3<Class<? extends SpecificRecord>, SpecificRecord, Row> getSpecificTestData() {
        Address addr = Address.newBuilder().setNum(42).setStreet("Main Street 42").setCity("Test City").setState("Test State").setZip("12345").build();
        Row rowAddr = new Row(5);
        rowAddr.setField(0, (Object)42);
        rowAddr.setField(1, (Object)"Main Street 42");
        rowAddr.setField(2, (Object)"Test City");
        rowAddr.setField(3, (Object)"Test State");
        rowAddr.setField(4, (Object)"12345");
        User user = User.newBuilder().setName("Charlie").setFavoriteNumber(null).setFavoriteColor("blue").setTypeLongTest(1337L).setTypeDoubleTest(1.337).setTypeNullTest(null).setTypeBoolTest(false).setTypeArrayString(Arrays.asList("hello", "world")).setTypeArrayBoolean(Arrays.asList(true, true, false)).setTypeNullableArray(null).setTypeEnum(Colors.RED).setTypeMap(Collections.singletonMap("test", 12L)).setTypeFixed(new Fixed16(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16})).setTypeUnion(12.0).setTypeNested(addr).setTypeBytes(ByteBuffer.allocate(10)).setTypeDate(LocalDate.parse((String)"2014-03-01")).setTypeTimeMillis(LocalTime.parse((String)"12:12:12")).setTypeTimeMicros(123456).setTypeTimestampMillis(DateTime.parse((String)"2014-03-01T12:12:12.321Z")).setTypeTimestampMicros(123456L).setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray())).build();
        Row rowUser = new Row(23);
        rowUser.setField(0, (Object)"Charlie");
        rowUser.setField(1, null);
        rowUser.setField(2, (Object)"blue");
        rowUser.setField(3, (Object)1337L);
        rowUser.setField(4, (Object)1.337);
        rowUser.setField(5, null);
        rowUser.setField(6, (Object)false);
        rowUser.setField(7, (Object)new String[]{"hello", "world"});
        rowUser.setField(8, (Object)new Boolean[]{true, true, false});
        rowUser.setField(9, null);
        rowUser.setField(10, (Object)"RED");
        rowUser.setField(11, Collections.singletonMap("test", 12L));
        rowUser.setField(12, (Object)new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        rowUser.setField(13, (Object)12.0);
        rowUser.setField(14, (Object)rowAddr);
        rowUser.setField(15, (Object)new byte[10]);
        rowUser.setField(16, (Object)Date.valueOf("2014-03-01"));
        rowUser.setField(17, (Object)Time.valueOf("12:12:12"));
        rowUser.setField(18, (Object)123456);
        rowUser.setField(19, (Object)Timestamp.valueOf("2014-03-01 12:12:12.321"));
        rowUser.setField(20, (Object)123456L);
        rowUser.setField(21, (Object)BigDecimal.valueOf(2000L, 2));
        rowUser.setField(22, (Object)BigDecimal.valueOf(2000L, 2));
        Tuple3 t = new Tuple3();
        t.f0 = User.class;
        t.f1 = user;
        t.f2 = rowUser;
        return t;
    }

    public static Tuple3<GenericRecord, Row, Schema> getGenericTestData() {
        String schemaString = "{\"type\":\"record\",\"name\":\"GenericUser\",\"namespace\":\"org.apache.flink.formats.avro.generated\",\"fields\": [{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"favorite_number\",\"type\":[\"int\",\"null\"]},{\"name\":\"favorite_color\",\"type\":[\"string\",\"null\"]},{\"name\":\"type_long_test\",\"type\":[\"long\",\"null\"]},{\"name\":\"type_double_test\",\"type\":\"double\"},{\"name\":\"type_null_test\",\"type\":[\"null\"]},{\"name\":\"type_bool_test\",\"type\":[\"boolean\"]},{\"name\":\"type_array_string\",\"type\":{\"type\":\"array\",\"items\":\"string\"}},{\"name\":\"type_array_boolean\",\"type\":{\"type\":\"array\",\"items\":\"boolean\"}},{\"name\":\"type_nullable_array\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"string\"}],\"default\":null},{\"name\":\"type_enum\",\"type\":{\"type\":\"enum\",\"name\":\"Colors\",\"symbols\":[\"RED\",\"GREEN\",\"BLUE\"]}},{\"name\":\"type_map\",\"type\":{\"type\":\"map\",\"values\":\"long\"}},{\"name\":\"type_fixed\",\"type\":[\"null\",{\"type\":\"fixed\",\"name\":\"Fixed16\",\"size\":16}],\"size\":16},{\"name\":\"type_union\",\"type\":[\"null\",\"boolean\",\"long\",\"double\"]},{\"name\":\"type_nested\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Address\",\"fields\":[{\"name\":\"num\",\"type\":\"int\"},{\"name\":\"street\",\"type\":\"string\"},{\"name\":\"city\",\"type\":\"string\"},{\"name\":\"state\",\"type\":\"string\"},{\"name\":\"zip\",\"type\":\"string\"}]}]},{\"name\":\"type_bytes\",\"type\":\"bytes\"},{\"name\":\"type_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"type_time_millis\",\"type\":{\"type\":\"int\",\"logicalType\":\"time-millis\"}},{\"name\":\"type_time_micros\",\"type\":{\"type\":\"int\",\"logicalType\":\"time-micros\"}},{\"name\":\"type_timestamp_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"type_timestamp_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"type_decimal_bytes\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}},{\"name\":\"type_decimal_fixed\",\"type\":{\"type\":\"fixed\",\"name\":\"Fixed2\",\"size\":2,\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}}]}";
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GenericUser\",\"namespace\":\"org.apache.flink.formats.avro.generated\",\"fields\": [{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"favorite_number\",\"type\":[\"int\",\"null\"]},{\"name\":\"favorite_color\",\"type\":[\"string\",\"null\"]},{\"name\":\"type_long_test\",\"type\":[\"long\",\"null\"]},{\"name\":\"type_double_test\",\"type\":\"double\"},{\"name\":\"type_null_test\",\"type\":[\"null\"]},{\"name\":\"type_bool_test\",\"type\":[\"boolean\"]},{\"name\":\"type_array_string\",\"type\":{\"type\":\"array\",\"items\":\"string\"}},{\"name\":\"type_array_boolean\",\"type\":{\"type\":\"array\",\"items\":\"boolean\"}},{\"name\":\"type_nullable_array\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"string\"}],\"default\":null},{\"name\":\"type_enum\",\"type\":{\"type\":\"enum\",\"name\":\"Colors\",\"symbols\":[\"RED\",\"GREEN\",\"BLUE\"]}},{\"name\":\"type_map\",\"type\":{\"type\":\"map\",\"values\":\"long\"}},{\"name\":\"type_fixed\",\"type\":[\"null\",{\"type\":\"fixed\",\"name\":\"Fixed16\",\"size\":16}],\"size\":16},{\"name\":\"type_union\",\"type\":[\"null\",\"boolean\",\"long\",\"double\"]},{\"name\":\"type_nested\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Address\",\"fields\":[{\"name\":\"num\",\"type\":\"int\"},{\"name\":\"street\",\"type\":\"string\"},{\"name\":\"city\",\"type\":\"string\"},{\"name\":\"state\",\"type\":\"string\"},{\"name\":\"zip\",\"type\":\"string\"}]}]},{\"name\":\"type_bytes\",\"type\":\"bytes\"},{\"name\":\"type_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"type_time_millis\",\"type\":{\"type\":\"int\",\"logicalType\":\"time-millis\"}},{\"name\":\"type_time_micros\",\"type\":{\"type\":\"int\",\"logicalType\":\"time-micros\"}},{\"name\":\"type_timestamp_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"type_timestamp_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"type_decimal_bytes\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}},{\"name\":\"type_decimal_fixed\",\"type\":{\"type\":\"fixed\",\"name\":\"Fixed2\",\"size\":2,\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}}]}");
        GenericData.Record addr = new GenericData.Record((Schema)schema.getField("type_nested").schema().getTypes().get(1));
        addr.put("num", (Object)42);
        addr.put("street", (Object)"Main Street 42");
        addr.put("city", (Object)"Test City");
        addr.put("state", (Object)"Test State");
        addr.put("zip", (Object)"12345");
        Row rowAddr = new Row(5);
        rowAddr.setField(0, (Object)42);
        rowAddr.setField(1, (Object)"Main Street 42");
        rowAddr.setField(2, (Object)"Test City");
        rowAddr.setField(3, (Object)"Test State");
        rowAddr.setField(4, (Object)"12345");
        GenericData.Record user = new GenericData.Record(schema);
        user.put("name", (Object)"Charlie");
        user.put("favorite_number", null);
        user.put("favorite_color", (Object)"blue");
        user.put("type_long_test", (Object)1337L);
        user.put("type_double_test", (Object)1.337);
        user.put("type_null_test", null);
        user.put("type_bool_test", (Object)false);
        user.put("type_array_string", Arrays.asList("hello", "world"));
        user.put("type_array_boolean", Arrays.asList(true, true, false));
        user.put("type_nullable_array", null);
        user.put("type_enum", (Object)new GenericData.EnumSymbol(schema.getField("type_enum").schema(), "RED"));
        user.put("type_map", Collections.singletonMap("test", 12L));
        user.put("type_fixed", (Object)new Fixed16(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        user.put("type_union", (Object)12.0);
        user.put("type_nested", (Object)addr);
        user.put("type_bytes", (Object)ByteBuffer.allocate(10));
        user.put("type_date", (Object)LocalDate.parse((String)"2014-03-01"));
        user.put("type_time_millis", (Object)LocalTime.parse((String)"12:12:12"));
        user.put("type_time_micros", (Object)123456);
        user.put("type_timestamp_millis", (Object)DateTime.parse((String)"2014-03-01T12:12:12.321Z"));
        user.put("type_timestamp_micros", (Object)123456L);
        user.put("type_decimal_bytes", (Object)ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        user.put("type_decimal_fixed", (Object)new GenericData.Fixed(schema.getField("type_decimal_fixed").schema(), BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
        Row rowUser = new Row(23);
        rowUser.setField(0, (Object)"Charlie");
        rowUser.setField(1, null);
        rowUser.setField(2, (Object)"blue");
        rowUser.setField(3, (Object)1337L);
        rowUser.setField(4, (Object)1.337);
        rowUser.setField(5, null);
        rowUser.setField(6, (Object)false);
        rowUser.setField(7, (Object)new String[]{"hello", "world"});
        rowUser.setField(8, (Object)new Boolean[]{true, true, false});
        rowUser.setField(9, null);
        rowUser.setField(10, (Object)"RED");
        rowUser.setField(11, Collections.singletonMap("test", 12L));
        rowUser.setField(12, (Object)new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        rowUser.setField(13, (Object)12.0);
        rowUser.setField(14, (Object)rowAddr);
        rowUser.setField(15, (Object)new byte[10]);
        rowUser.setField(16, (Object)Date.valueOf("2014-03-01"));
        rowUser.setField(17, (Object)Time.valueOf("12:12:12"));
        rowUser.setField(18, (Object)123456);
        rowUser.setField(19, (Object)Timestamp.valueOf("2014-03-01 12:12:12.321"));
        rowUser.setField(20, (Object)123456L);
        rowUser.setField(21, (Object)BigDecimal.valueOf(2000L, 2));
        rowUser.setField(22, (Object)BigDecimal.valueOf(2000L, 2));
        Tuple3 t = new Tuple3();
        t.f0 = user;
        t.f1 = rowUser;
        t.f2 = schema;
        return t;
    }

    public static byte[] writeRecord(GenericRecord record, Schema schema) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)stream, null);
        new GenericDatumWriter(schema).write((Object)record, (Encoder)encoder);
        encoder.flush();
        return stream.toByteArray();
    }
}

