/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.Avro;
import org.apache.flink.table.descriptors.AvroValidator;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorTestBase;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.junit.Test;

public class AvroTest
extends DescriptorTestBase {
    @Test(expected=ValidationException.class)
    public void testMissingRecordClass() {
        this.removePropertyAndVerify(this.descriptors().get(0), "format.record-class");
    }

    @Test(expected=ValidationException.class)
    public void testRecordClassAndAvroSchema() {
        this.addPropertyAndVerify(this.descriptors().get(0), "format.avro-schema", "{...}");
    }

    public List<Descriptor> descriptors() {
        Avro desc1 = new Avro().recordClass(User.class);
        Avro desc2 = new Avro().avroSchema("{...}");
        return Arrays.asList(desc1, desc2);
    }

    public List<Map<String, String>> properties() {
        HashMap<String, String> props1 = new HashMap<String, String>();
        props1.put("format.type", "avro");
        props1.put("format.property-version", "1");
        props1.put("format.record-class", "org.apache.flink.formats.avro.generated.User");
        HashMap<String, String> props2 = new HashMap<String, String>();
        props2.put("format.type", "avro");
        props2.put("format.property-version", "1");
        props2.put("format.avro-schema", "{...}");
        return Arrays.asList(props1, props2);
    }

    public DescriptorValidator validator() {
        return new AvroValidator();
    }
}

