/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.FileSystemTableSink;
import org.apache.flink.connector.file.table.FileSystemTableSource;
import org.apache.flink.connector.file.table.factories.BulkReaderFormatFactory;
import org.apache.flink.connector.file.table.factories.BulkWriterFormatFactory;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DecodingFormatFactory;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.EncodingFormatFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

@Internal
public class FileSystemTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "filesystem";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        this.validate(helper);
        return new FileSystemTableSource(context.getObjectIdentifier(), context.getPhysicalRowDataType(), context.getCatalogTable().getPartitionKeys(), helper.getOptions(), this.discoverDecodingFormat(context, BulkReaderFormatFactory.class), this.discoverDecodingFormat(context, DeserializationFormatFactory.class));
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        this.validate(helper);
        return new FileSystemTableSink(context.getObjectIdentifier(), context.getPhysicalRowDataType(), context.getCatalogTable().getPartitionKeys(), helper.getOptions(), this.discoverDecodingFormat(context, BulkReaderFormatFactory.class), this.discoverDecodingFormat(context, DeserializationFormatFactory.class), this.discoverEncodingFormat(context, BulkWriterFormatFactory.class), this.discoverEncodingFormat(context, SerializationFormatFactory.class));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(FileSystemConnectorOptions.PATH);
        options.add(FactoryUtil.FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FileSystemConnectorOptions.PARTITION_DEFAULT_NAME);
        options.add(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL);
        options.add(FileSystemConnectorOptions.SINK_ROLLING_POLICY_FILE_SIZE);
        options.add(FileSystemConnectorOptions.SINK_ROLLING_POLICY_ROLLOVER_INTERVAL);
        options.add(FileSystemConnectorOptions.SINK_ROLLING_POLICY_INACTIVITY_INTERVAL);
        options.add(FileSystemConnectorOptions.SINK_ROLLING_POLICY_CHECK_INTERVAL);
        options.add(FileSystemConnectorOptions.SINK_SHUFFLE_BY_PARTITION);
        options.add(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_KIND);
        options.add(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_CLASS);
        options.add(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_FORMATTER);
        options.add(FileSystemConnectorOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN);
        options.add(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER);
        options.add(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY);
        options.add(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_WATERMARK_TIME_ZONE);
        options.add(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND);
        options.add(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_CLASS);
        options.add(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME);
        options.add(FileSystemConnectorOptions.AUTO_COMPACTION);
        options.add(FileSystemConnectorOptions.COMPACTION_FILE_SIZE);
        options.add(FileSystemConnectorOptions.SINK_PARALLELISM);
        return options;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(FileSystemConnectorOptions.PATH, FileSystemConnectorOptions.PARTITION_DEFAULT_NAME, FileSystemConnectorOptions.SINK_ROLLING_POLICY_FILE_SIZE, FileSystemConnectorOptions.SINK_ROLLING_POLICY_ROLLOVER_INTERVAL, FileSystemConnectorOptions.SINK_ROLLING_POLICY_CHECK_INTERVAL, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_WATERMARK_TIME_ZONE, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_KIND, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_POLICY_CLASS, FileSystemConnectorOptions.SINK_PARTITION_COMMIT_SUCCESS_FILE_NAME, FileSystemConnectorOptions.COMPACTION_FILE_SIZE).collect(Collectors.toSet());
    }

    private void validate(FactoryUtil.TableFactoryHelper helper) {
        helper.validateExcept(new String[]{(String)helper.getOptions().get(FactoryUtil.FORMAT) + "."});
        String watermarkTimeZone = (String)helper.getOptions().get(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_WATERMARK_TIME_ZONE);
        if (watermarkTimeZone.startsWith("UTC+") || watermarkTimeZone.startsWith("UTC-") || ZoneId.SHORT_IDS.containsKey(watermarkTimeZone)) {
            throw new ValidationException(String.format("The supported watermark time zone is either a full name such as 'America/Los_Angeles', or a custom time zone id such as 'GMT-08:00', but configured time zone is '%s'.", watermarkTimeZone));
        }
    }

    private <I, F extends DecodingFormatFactory<I>> DecodingFormat<I> discoverDecodingFormat(DynamicTableFactory.Context context, Class<F> formatFactoryClass) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        if (this.formatFactoryExists(context, formatFactoryClass)) {
            return helper.discoverDecodingFormat(formatFactoryClass, FactoryUtil.FORMAT);
        }
        return null;
    }

    private <I, F extends EncodingFormatFactory<I>> EncodingFormat<I> discoverEncodingFormat(DynamicTableFactory.Context context, Class<F> formatFactoryClass) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        if (this.formatFactoryExists(context, formatFactoryClass)) {
            return helper.discoverEncodingFormat(formatFactoryClass, FactoryUtil.FORMAT);
        }
        return null;
    }

    private boolean formatFactoryExists(DynamicTableFactory.Context context, Class<?> factoryClass) {
        Configuration options = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
        String identifier = (String)options.get(FactoryUtil.FORMAT);
        if (identifier == null) {
            throw new ValidationException(String.format("Table options do not contain an option key '%s' for discovering a format.", FactoryUtil.FORMAT.key()));
        }
        LinkedList factories = new LinkedList();
        ServiceLoader.load(Factory.class, context.getClassLoader()).iterator().forEachRemaining(factories::add);
        List foundFactories = factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).collect(Collectors.toList());
        List matchingFactories = foundFactories.stream().filter(f -> f.factoryIdentifier().equals(identifier)).collect(Collectors.toList());
        return !matchingFactories.isEmpty();
    }
}

