/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.table.RowPartitionComputer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.PartitionPathUtils;

@FunctionalInterface
@Internal
public interface PartitionFieldExtractor<T extends FileSourceSplit>
extends Serializable {
    public Object extract(T var1, String var2, LogicalType var3);

    public static PartitionFieldExtractor<FileSourceSplit> forFileSystem(String defaultPartValue) {
        return (split, fieldName, fieldType) -> {
            LinkedHashMap partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)split.path());
            if (!partitionSpec.containsKey(fieldName)) {
                throw new RuntimeException("Cannot find the partition value from path for partition: " + fieldName);
            }
            String valueStr = (String)partitionSpec.get(fieldName);
            valueStr = valueStr.equals(defaultPartValue) ? null : valueStr;
            return RowPartitionComputer.restorePartValueFromType(valueStr, fieldType);
        };
    }
}

