/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.InputSplit;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HadoopToStringUtil {
    public static String toString(InputSplit input) throws IOException, InterruptedException {
        if (input == null) {
            return "null";
        }
        String result = "InputSplit::";
        result = result + " length:" + input.getLength();
        result = result + " locations: " + Arrays.toString(input.getLocations());
        result = result + " toString(): " + input.toString();
        return result;
    }

    public static String toString(List<InputSplit> input) throws IOException, InterruptedException {
        if (input == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder("List<InputSplit>::");
        result.append(" size:").append(input.size()).append(" elements: [");
        for (InputSplit is : input) {
            result.append(HadoopToStringUtil.toString(is)).append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public static String toString(TaskAttemptContext input) {
        if (input == null) {
            return "null";
        }
        String result = "TaskAttemptContext::";
        result = result + " TaskAttemptID:" + input.getTaskAttemptID();
        result = result + " Status:" + input.getStatus();
        return result;
    }

    public static String toString(JobContext input) {
        if (input == null) {
            return "null";
        }
        String result = "JobContext::";
        result = result + " JobName:" + input.getJobName();
        result = result + " Jar:" + input.getJar();
        return result;
    }
}

