/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs.writer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.gs.storage.GSBlobIdentifier;
import org.apache.flink.fs.gs.writer.GSCommitRecoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSCommitRecoverableSerializer
implements SimpleVersionedSerializer<GSCommitRecoverable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GSCommitRecoverableSerializer.class);
    private static final int SERIALIZER_VERSION = 1;
    public static final GSCommitRecoverableSerializer INSTANCE = new GSCommitRecoverableSerializer();

    private GSCommitRecoverableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    static void serializeCommitRecoverable(GSCommitRecoverable recoverable, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(recoverable.finalBlobIdentifier.bucketName);
        dataOutputStream.writeUTF(recoverable.finalBlobIdentifier.objectName);
        dataOutputStream.writeInt(recoverable.componentObjectIds.size());
        for (UUID componentObjectId : recoverable.componentObjectIds) {
            dataOutputStream.writeLong(componentObjectId.getMostSignificantBits());
            dataOutputStream.writeLong(componentObjectId.getLeastSignificantBits());
        }
    }

    public byte[] serialize(GSCommitRecoverable recoverable) throws IOException {
        LOGGER.trace("Serializing recoverable {}", (Object)recoverable);
        Preconditions.checkNotNull((Object)recoverable);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                GSCommitRecoverableSerializer.serializeCommitRecoverable(recoverable, dataOutputStream);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    static GSCommitRecoverable deserializeCommitRecoverable(DataInputStream dataInputStream) throws IOException {
        String finalBucketName = dataInputStream.readUTF();
        String finalObjectName = dataInputStream.readUTF();
        GSBlobIdentifier finalBlobIdentifier = new GSBlobIdentifier(finalBucketName, finalObjectName);
        ArrayList<UUID> componentObjectIds = new ArrayList<UUID>();
        int count = dataInputStream.readInt();
        for (int i = 0; i < count; ++i) {
            long msbValue = dataInputStream.readLong();
            long lsbValue = dataInputStream.readLong();
            UUID componentObjectId = new UUID(msbValue, lsbValue);
            componentObjectIds.add(componentObjectId);
        }
        GSCommitRecoverable recoverable = new GSCommitRecoverable(finalBlobIdentifier, componentObjectIds);
        LOGGER.trace("Deserialized commit recoverable {}", (Object)recoverable);
        return recoverable;
    }

    /*
     * Exception decompiling
     */
    public GSCommitRecoverable deserialize(int version, byte[] serialized) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

