/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CreateFlag;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileChecksum;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FsServerDefaults;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FsStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Options;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progressable;

public class GoogleHadoopFS
extends AbstractFileSystem {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private GoogleHadoopFileSystem ghfs;

    public GoogleHadoopFS(URI uri, Configuration conf) throws URISyntaxException, IOException {
        this(new GoogleHadoopFileSystem(), uri, conf);
    }

    public GoogleHadoopFS(GoogleHadoopFileSystem ghfs, URI uri, Configuration conf) throws URISyntaxException, IOException {
        super(uri, ghfs.getScheme(), true, 0);
        Preconditions.checkArgument(ghfs != null, "ghfs must not be null");
        this.ghfs = ghfs;
        ghfs.initialize(uri, conf);
    }

    @Override
    public FSDataOutputStream createInternal(Path file, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createInternal(file: %s, flag: %s, absolutePermission: %s, bufferSize: %d, replication: %b, blockSize: %d, progress: %s, checksumOpt: %s, createParent: %b)", file, flag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent);
        if (!createParent) {
            ((GoogleLogger.Api)logger.atFine()).log("Ignoring createParent=false. Creating parents anyways.");
        }
        boolean overwriteFile = true;
        return this.ghfs.create(file, absolutePermission, overwriteFile, bufferSize, replication, blockSize, progress);
    }

    @Override
    public int getUriDefaultPort() {
        int defaultPort = this.ghfs.getDefaultPort();
        ((GoogleLogger.Api)logger.atFiner()).log("getUriDefaultPort(): %d", defaultPort);
        return defaultPort;
    }

    @Override
    public URI getUri() {
        return this.ghfs.getUri();
    }

    @Override
    public boolean isValidName(String src) {
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkPath(Path path) {
        super.checkPath(path);
        this.ghfs.checkPath(path);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getServerDefaults()");
        return this.ghfs.getServerDefaults();
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("mkdir(dir: %s, permission: %s, createParent %b)", dir, permission, createParent);
        if (!createParent) {
            ((GoogleLogger.Api)logger.atFine()).log("Ignoring createParent=false. Creating parents anyways.");
        }
        this.ghfs.mkdirs(dir, permission);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("delete(path: %s, recursive: %b)", (Object)f, recursive);
        return this.ghfs.delete(f, recursive);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(path: %s, bufferSize: %d)", (Object)f, bufferSize);
        return this.ghfs.open(f, bufferSize);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setReplication(path: %s, replication: %d)", (Object)f, replication);
        return this.ghfs.setReplication(f, replication);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("renameInternal(src: %s, dst: %s)", (Object)src, (Object)dst);
        this.ghfs.renameInternal(src, dst);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setPermission(path: %s, permission: %s)", (Object)f, (Object)permission);
        this.ghfs.setPermission(f, permission);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setOwner(path: %s, username: %s, groupname: %s)", f, username, groupname);
        this.ghfs.setOwner(f, username, groupname);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setTimes(path: %s, mtime: %d, atime: %d)", f, mtime, atime);
        this.ghfs.setTimes(f, mtime, atime);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getFileChecksum(path: %s)", f);
        return this.ghfs.getFileChecksum(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getFileStatus(path: %s)", f);
        return this.ghfs.getFileStatus(f);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getFileBlockLocations(path: %s, start: %d, len: %d)", f, start, len);
        return this.ghfs.getFileBlockLocations(f, start, len);
    }

    @Override
    public FsStatus getFsStatus() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getStatus()");
        return this.ghfs.getStatus();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listStatus(path: %s)", f);
        return this.ghfs.listStatus(f);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        ((GoogleLogger.Api)logger.atFiner()).log("setVerifyChecksum(verifyChecksum: %b)", verifyChecksum);
        this.ghfs.setVerifyChecksum(verifyChecksum);
    }
}

