/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_CreateObjectOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class CreateObjectOptions {
    public static final String CONTENT_TYPE_DEFAULT = "application/octet-stream";
    public static final CreateObjectOptions DEFAULT_NO_OVERWRITE = CreateObjectOptions.builder().build();
    public static final CreateObjectOptions DEFAULT_OVERWRITE = CreateObjectOptions.builder().setOverwriteExisting(true).build();

    public static Builder builder() {
        return new AutoValue_CreateObjectOptions.Builder().setContentEncoding(null).setContentType(CONTENT_TYPE_DEFAULT).setEnsureEmptyObjectsMetadataMatch(true).setKmsKeyName(null).setMetadata(ImmutableMap.of()).setOverwriteExisting(false);
    }

    public abstract Builder toBuilder();

    @Nullable
    public abstract String getContentEncoding();

    @Nullable
    public abstract String getContentType();

    public abstract boolean isEnsureEmptyObjectsMetadataMatch();

    @Nullable
    public abstract String getKmsKeyName();

    public abstract ImmutableMap<String, byte[]> getMetadata();

    public abstract boolean isOverwriteExisting();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setContentEncoding(String var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setEnsureEmptyObjectsMetadataMatch(boolean var1);

        public abstract Builder setKmsKeyName(String var1);

        public abstract Builder setMetadata(Map<String, byte[]> var1);

        public abstract Builder setOverwriteExisting(boolean var1);

        protected abstract CreateObjectOptions autoBuild();

        public CreateObjectOptions build() {
            CreateObjectOptions options = this.autoBuild();
            Preconditions.checkArgument(!options.getMetadata().containsKey("Content-Encoding"), "The Content-Encoding must be provided explicitly via the 'contentEncoding' parameter");
            Preconditions.checkArgument(!options.getMetadata().containsKey("Content-Type"), "The Content-Type must be provided explicitly via the 'contentType' parameter");
            return options;
        }
    }
}

