/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.StorageStatistics;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemStorageStatistics
extends StorageStatistics {
    private final FileSystem.Statistics stats;
    private static final String[] KEYS = new String[]{"bytesRead", "bytesWritten", "readOps", "largeReadOps", "writeOps", "bytesReadLocalHost", "bytesReadDistanceOfOneOrTwo", "bytesReadDistanceOfThreeOrFour", "bytesReadDistanceOfFiveOrLarger", "bytesReadErasureCoded"};

    private static Long fetch(FileSystem.Statistics.StatisticsData data, String key) {
        Preconditions.checkArgument(key != null, "The stat key of FileSystemStorageStatistics should not be null!");
        switch (key) {
            case "bytesRead": {
                return data.getBytesRead();
            }
            case "bytesWritten": {
                return data.getBytesWritten();
            }
            case "readOps": {
                return data.getReadOps() + data.getLargeReadOps();
            }
            case "largeReadOps": {
                return data.getLargeReadOps();
            }
            case "writeOps": {
                return data.getWriteOps();
            }
            case "bytesReadLocalHost": {
                return data.getBytesReadLocalHost();
            }
            case "bytesReadDistanceOfOneOrTwo": {
                return data.getBytesReadDistanceOfOneOrTwo();
            }
            case "bytesReadDistanceOfThreeOrFour": {
                return data.getBytesReadDistanceOfThreeOrFour();
            }
            case "bytesReadDistanceOfFiveOrLarger": {
                return data.getBytesReadDistanceOfFiveOrLarger();
            }
            case "bytesReadErasureCoded": {
                return data.getBytesReadErasureCoded();
            }
        }
        return null;
    }

    FileSystemStorageStatistics(String name, FileSystem.Statistics stats) {
        super(name);
        Preconditions.checkArgument(stats != null, "FileSystem.Statistics can not be null");
        Preconditions.checkArgument(stats.getData() != null, "FileSystem.Statistics can not have null data");
        this.stats = stats;
    }

    @Override
    public String getScheme() {
        return this.stats.getScheme();
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return new LongStatisticIterator(this.stats.getData());
    }

    @Override
    public Long getLong(String key) {
        return FileSystemStorageStatistics.fetch(this.stats.getData(), key);
    }

    @Override
    public boolean isTracked(String key) {
        for (String k : KEYS) {
            if (!k.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.stats.reset();
    }

    private static class LongStatisticIterator
    implements Iterator<StorageStatistics.LongStatistic> {
        private final FileSystem.Statistics.StatisticsData data;
        private int keyIdx;

        LongStatisticIterator(FileSystem.Statistics.StatisticsData data) {
            this.data = data;
            this.keyIdx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.keyIdx < KEYS.length;
        }

        @Override
        public StorageStatistics.LongStatistic next() {
            if (this.keyIdx >= KEYS.length) {
                throw new NoSuchElementException();
            }
            String key = KEYS[this.keyIdx++];
            Long val = FileSystemStorageStatistics.fetch(this.data, key);
            return new StorageStatistics.LongStatistic(key, val);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

