/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.StreamCapabilities;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class StoreImplementationUtils {
    private StoreImplementationUtils() {
    }

    public static boolean isProbeForSyncable(String capability) {
        return capability.equalsIgnoreCase("hsync") || capability.equalsIgnoreCase("hflush");
    }

    static boolean objectHasCapability(Object object, String capability) {
        if (object instanceof StreamCapabilities) {
            return ((StreamCapabilities)object).hasCapability(capability);
        }
        return false;
    }

    public static boolean hasCapability(OutputStream out, String capability) {
        return StoreImplementationUtils.objectHasCapability(out, capability);
    }

    public static boolean hasCapability(InputStream in, String capability) {
        return StoreImplementationUtils.objectHasCapability(in, capability);
    }
}

