/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.ChecksumException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CreateFlag;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Options;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.StreamCapabilities;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Syncable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.DataInputBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.DataOutputBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.IntWritable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.RawComparator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.UTF8;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.VersionMismatchException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableComparator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableName;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CodecPool;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.Compressor;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.Decompressor;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.GzipCodec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.serializer.Deserializer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.serializer.Serializer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.MergeSort;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.NativeCodeLoader;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Options;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.PriorityQueue;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progress;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progressable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.ReflectionUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFile {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceFile.class);
    private static final byte BLOCK_COMPRESS_VERSION = 4;
    private static final byte CUSTOM_COMPRESS_VERSION = 5;
    private static final byte VERSION_WITH_METADATA = 6;
    private static byte[] VERSION = new byte[]{83, 69, 81, 6};
    private static final int SYNC_ESCAPE = -1;
    private static final int SYNC_HASH_SIZE = 16;
    private static final int SYNC_SIZE = 20;
    public static final int SYNC_INTERVAL = 102400;

    private SequenceFile() {
    }

    public static CompressionType getDefaultCompressionType(Configuration job) {
        String name = job.get("io.seqfile.compression.type");
        return name == null ? CompressionType.RECORD : CompressionType.valueOf(name);
    }

    public static void setDefaultCompressionType(Configuration job, CompressionType val) {
        job.set("io.seqfile.compression.type", val.toString());
    }

    public static Writer createWriter(Configuration conf, Writer.Option ... opts) throws IOException {
        CompressionType kind;
        Writer.CompressionOption compressionOption = Options.getOption(Writer.CompressionOption.class, opts);
        if (compressionOption != null) {
            kind = compressionOption.getValue();
        } else {
            kind = SequenceFile.getDefaultCompressionType(conf);
            opts = Options.prependOptions(opts, Writer.compression(kind));
        }
        switch (kind) {
            default: {
                return new Writer(conf, opts);
            }
            case RECORD: {
                return new RecordCompressWriter(conf, opts);
            }
            case BLOCK: 
        }
        return new BlockCompressWriter(conf, opts);
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass) throws IOException {
        return SequenceFile.createWriter(conf, Writer.filesystem(fs), Writer.file(name), Writer.keyClass(keyClass), Writer.valueClass(valClass));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType) throws IOException {
        return SequenceFile.createWriter(conf, Writer.filesystem(fs), Writer.file(name), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, Progressable progress) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType), Writer.progressable(progress));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec), Writer.progressable(progress), Writer.metadata(metadata));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, CompressionType compressionType, CompressionCodec codec, Progressable progress, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.bufferSize(bufferSize), Writer.replication(replication), Writer.blockSize(blockSize), Writer.compression(compressionType, codec), Writer.progressable(progress), Writer.metadata(metadata));
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, boolean createParent, CompressionType compressionType, CompressionCodec codec, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(FileContext.getFileContext(fs.getUri(), conf), conf, name, keyClass, valClass, compressionType, codec, metadata, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), Options.CreateOpts.bufferSize(bufferSize), createParent ? Options.CreateOpts.createParent() : Options.CreateOpts.donotCreateParent(), Options.CreateOpts.repFac(replication), Options.CreateOpts.blockSize(blockSize));
    }

    public static Writer createWriter(FileContext fc, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Metadata metadata, EnumSet<CreateFlag> createFlag, Options.CreateOpts ... opts) throws IOException {
        return SequenceFile.createWriter(conf, fc.create(name, createFlag, opts), keyClass, valClass, compressionType, codec, metadata).ownStream();
    }

    @Deprecated
    public static Writer createWriter(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Progressable progress) throws IOException {
        return SequenceFile.createWriter(conf, Writer.file(name), Writer.filesystem(fs), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec), Writer.progressable(progress));
    }

    @Deprecated
    public static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec, Metadata metadata) throws IOException {
        return SequenceFile.createWriter(conf, Writer.stream(out), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec), Writer.metadata(metadata));
    }

    @Deprecated
    public static Writer createWriter(Configuration conf, FSDataOutputStream out, Class keyClass, Class valClass, CompressionType compressionType, CompressionCodec codec) throws IOException {
        return SequenceFile.createWriter(conf, Writer.stream(out), Writer.keyClass(keyClass), Writer.valueClass(valClass), Writer.compression(compressionType, codec));
    }

    private static int getBufferSize(Configuration conf) {
        return conf.getInt("io.file.buffer.size", 4096);
    }

    public static class Sorter {
        private RawComparator comparator;
        private MergeSort mergeSort;
        private Path[] inFiles;
        private Path outFile;
        private int memory;
        private int factor;
        private FileSystem fs = null;
        private Class keyClass;
        private Class valClass;
        private Configuration conf;
        private Metadata metadata;
        private Progressable progressable = null;

        public Sorter(FileSystem fs, Class<? extends WritableComparable> keyClass, Class valClass, Configuration conf) {
            this(fs, WritableComparator.get(keyClass, conf), keyClass, valClass, conf);
        }

        public Sorter(FileSystem fs, RawComparator comparator, Class keyClass, Class valClass, Configuration conf) {
            this(fs, comparator, keyClass, valClass, conf, new Metadata());
        }

        public Sorter(FileSystem fs, RawComparator comparator, Class keyClass, Class valClass, Configuration conf, Metadata metadata) {
            this.fs = fs;
            this.comparator = comparator;
            this.keyClass = keyClass;
            this.valClass = valClass;
            this.memory = conf.get("io.sort.mb") != null ? conf.getInt("io.sort.mb", 100) * 1024 * 1024 : conf.getInt("seq.io.sort.mb", 100) * 1024 * 1024;
            this.factor = conf.get("io.sort.factor") != null ? conf.getInt("io.sort.factor", 100) : conf.getInt("seq.io.sort.factor", 100);
            this.conf = conf;
            this.metadata = metadata;
        }

        public void setFactor(int factor) {
            this.factor = factor;
        }

        public int getFactor() {
            return this.factor;
        }

        public void setMemory(int memory) {
            this.memory = memory;
        }

        public int getMemory() {
            return this.memory;
        }

        public void setProgressable(Progressable progressable) {
            this.progressable = progressable;
        }

        public void sort(Path[] inFiles, Path outFile, boolean deleteInput) throws IOException {
            if (this.fs.exists(outFile)) {
                throw new IOException("already exists: " + outFile);
            }
            this.inFiles = inFiles;
            this.outFile = outFile;
            int segments = this.sortPass(deleteInput);
            if (segments > 1) {
                this.mergePass(outFile.getParent());
            }
        }

        public RawKeyValueIterator sortAndIterate(Path[] inFiles, Path tempDir, boolean deleteInput) throws IOException {
            Path outFile = new Path(tempDir + "/" + "all.2");
            if (this.fs.exists(outFile)) {
                throw new IOException("already exists: " + outFile);
            }
            this.inFiles = inFiles;
            this.outFile = outFile;
            int segments = this.sortPass(deleteInput);
            if (segments > 1) {
                return this.merge(outFile.suffix(".0"), outFile.suffix(".0.index"), tempDir);
            }
            if (segments == 1) {
                return this.merge(new Path[]{outFile}, true, tempDir);
            }
            return null;
        }

        public void sort(Path inFile, Path outFile) throws IOException {
            this.sort(new Path[]{inFile}, outFile, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int sortPass(boolean deleteInput) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("running sort pass");
            }
            SortPass sortPass = new SortPass();
            sortPass.setProgressable(this.progressable);
            this.mergeSort = new MergeSort(sortPass.new SortPass.SeqFileComparator());
            try {
                int n = sortPass.run(deleteInput);
                return n;
            }
            finally {
                sortPass.close();
            }
        }

        public RawKeyValueIterator merge(List<SegmentDescriptor> segments, Path tmpDir) throws IOException {
            MergeQueue mQueue = new MergeQueue(segments, tmpDir, this.progressable);
            return mQueue.merge();
        }

        public RawKeyValueIterator merge(Path[] inNames, boolean deleteInputs, Path tmpDir) throws IOException {
            return this.merge(inNames, deleteInputs, inNames.length < this.factor ? inNames.length : this.factor, tmpDir);
        }

        public RawKeyValueIterator merge(Path[] inNames, boolean deleteInputs, int factor, Path tmpDir) throws IOException {
            ArrayList<SegmentDescriptor> a = new ArrayList<SegmentDescriptor>();
            for (int i = 0; i < inNames.length; ++i) {
                SegmentDescriptor s2 = new SegmentDescriptor(0L, this.fs.getFileStatus(inNames[i]).getLen(), inNames[i]);
                s2.preserveInput(!deleteInputs);
                s2.doSync();
                a.add(s2);
            }
            this.factor = factor;
            MergeQueue mQueue = new MergeQueue(a, tmpDir, this.progressable);
            return mQueue.merge();
        }

        public RawKeyValueIterator merge(Path[] inNames, Path tempDir, boolean deleteInputs) throws IOException {
            this.outFile = new Path(tempDir + "/" + "merged");
            ArrayList<SegmentDescriptor> a = new ArrayList<SegmentDescriptor>();
            for (int i = 0; i < inNames.length; ++i) {
                SegmentDescriptor s2 = new SegmentDescriptor(0L, this.fs.getFileStatus(inNames[i]).getLen(), inNames[i]);
                s2.preserveInput(!deleteInputs);
                s2.doSync();
                a.add(s2);
            }
            this.factor = inNames.length < this.factor ? inNames.length : this.factor;
            MergeQueue mQueue = new MergeQueue(a, tempDir, this.progressable);
            return mQueue.merge();
        }

        public Writer cloneFileAttributes(Path inputFile, Path outputFile, Progressable prog) throws IOException {
            Reader reader = new Reader(this.conf, Reader.file(inputFile), new Reader.OnlyHeaderOption());
            CompressionType compress = reader.getCompressionType();
            CompressionCodec codec = reader.getCompressionCodec();
            reader.close();
            Writer writer = SequenceFile.createWriter(this.conf, Writer.file(outputFile), Writer.keyClass(this.keyClass), Writer.valueClass(this.valClass), Writer.compression(compress, codec), Writer.progressable(prog));
            return writer;
        }

        public void writeFile(RawKeyValueIterator records, Writer writer) throws IOException {
            while (records.next()) {
                writer.appendRaw(records.getKey().getData(), 0, records.getKey().getLength(), records.getValue());
            }
            writer.sync();
        }

        public void merge(Path[] inFiles, Path outFile) throws IOException {
            if (this.fs.exists(outFile)) {
                throw new IOException("already exists: " + outFile);
            }
            RawKeyValueIterator r = this.merge(inFiles, false, outFile.getParent());
            Writer writer = this.cloneFileAttributes(inFiles[0], outFile, null);
            this.writeFile(r, writer);
            writer.close();
        }

        private int mergePass(Path tmpDir) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("running merge pass");
            }
            Writer writer = this.cloneFileAttributes(this.outFile.suffix(".0"), this.outFile, null);
            RawKeyValueIterator r = this.merge(this.outFile.suffix(".0"), this.outFile.suffix(".0.index"), tmpDir);
            this.writeFile(r, writer);
            writer.close();
            return 0;
        }

        private RawKeyValueIterator merge(Path inName, Path indexIn, Path tmpDir) throws IOException {
            SegmentContainer container = new SegmentContainer(inName, indexIn);
            MergeQueue mQueue = new MergeQueue(container.getSegmentList(), tmpDir, this.progressable);
            return mQueue.merge();
        }

        private class SegmentContainer {
            private int numSegmentsCleanedUp = 0;
            private int numSegmentsContained;
            private Path inName;
            private ArrayList<SegmentDescriptor> segments = new ArrayList();

            public SegmentContainer(Path inName, Path indexIn) throws IOException {
                FSDataInputStream fsIndexIn = Sorter.this.fs.open(indexIn);
                long end = Sorter.this.fs.getFileStatus(indexIn).getLen();
                while (fsIndexIn.getPos() < end) {
                    long segmentOffset = WritableUtils.readVLong(fsIndexIn);
                    long segmentLength = WritableUtils.readVLong(fsIndexIn);
                    Path segmentName = inName;
                    this.segments.add(new LinkedSegmentsDescriptor(segmentOffset, segmentLength, segmentName, this));
                }
                fsIndexIn.close();
                Sorter.this.fs.delete(indexIn, true);
                this.numSegmentsContained = this.segments.size();
                this.inName = inName;
            }

            public List<SegmentDescriptor> getSegmentList() {
                return this.segments;
            }

            public void cleanup() throws IOException {
                ++this.numSegmentsCleanedUp;
                if (this.numSegmentsCleanedUp == this.numSegmentsContained) {
                    Sorter.this.fs.delete(this.inName, true);
                }
            }
        }

        private class LinkedSegmentsDescriptor
        extends SegmentDescriptor {
            SegmentContainer parentContainer;

            public LinkedSegmentsDescriptor(long segmentOffset, long segmentLength, Path segmentPathName, SegmentContainer parent) {
                super(segmentOffset, segmentLength, segmentPathName);
                this.parentContainer = null;
                this.parentContainer = parent;
            }

            @Override
            public void cleanup() throws IOException {
                ((SegmentDescriptor)this).close();
                if (super.shouldPreserveInput()) {
                    return;
                }
                this.parentContainer.cleanup();
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof LinkedSegmentsDescriptor)) {
                    return false;
                }
                return super.equals(o);
            }
        }

        public class SegmentDescriptor
        implements Comparable {
            long segmentOffset;
            long segmentLength;
            Path segmentPathName;
            boolean ignoreSync = true;
            private Reader in = null;
            private DataOutputBuffer rawKey = null;
            private boolean preserveInput = false;

            public SegmentDescriptor(long segmentOffset, long segmentLength, Path segmentPathName) {
                this.segmentOffset = segmentOffset;
                this.segmentLength = segmentLength;
                this.segmentPathName = segmentPathName;
            }

            public void doSync() {
                this.ignoreSync = false;
            }

            public void preserveInput(boolean preserve) {
                this.preserveInput = preserve;
            }

            public boolean shouldPreserveInput() {
                return this.preserveInput;
            }

            public int compareTo(Object o) {
                SegmentDescriptor that = (SegmentDescriptor)o;
                if (this.segmentLength != that.segmentLength) {
                    return this.segmentLength < that.segmentLength ? -1 : 1;
                }
                if (this.segmentOffset != that.segmentOffset) {
                    return this.segmentOffset < that.segmentOffset ? -1 : 1;
                }
                return this.segmentPathName.toString().compareTo(that.segmentPathName.toString());
            }

            public boolean equals(Object o) {
                if (!(o instanceof SegmentDescriptor)) {
                    return false;
                }
                SegmentDescriptor that = (SegmentDescriptor)o;
                return this.segmentLength == that.segmentLength && this.segmentOffset == that.segmentOffset && this.segmentPathName.toString().equals(that.segmentPathName.toString());
            }

            public int hashCode() {
                return 629 + (int)(this.segmentOffset ^ this.segmentOffset >>> 32);
            }

            public boolean nextRawKey() throws IOException {
                if (this.in == null) {
                    int bufferSize = SequenceFile.getBufferSize(Sorter.this.conf);
                    Reader reader = new Reader(Sorter.this.conf, Reader.file(this.segmentPathName), Reader.bufferSize(bufferSize), Reader.start(this.segmentOffset), Reader.length(this.segmentLength));
                    if (this.ignoreSync) {
                        reader.ignoreSync();
                    }
                    if (reader.getKeyClass() != Sorter.this.keyClass) {
                        throw new IOException("wrong key class: " + reader.getKeyClass() + " is not " + Sorter.this.keyClass);
                    }
                    if (reader.getValueClass() != Sorter.this.valClass) {
                        throw new IOException("wrong value class: " + reader.getValueClass() + " is not " + Sorter.this.valClass);
                    }
                    this.in = reader;
                    this.rawKey = new DataOutputBuffer();
                }
                this.rawKey.reset();
                int keyLength = this.in.nextRawKey(this.rawKey);
                return keyLength >= 0;
            }

            public int nextRawValue(ValueBytes rawValue) throws IOException {
                int valLength = this.in.nextRawValue(rawValue);
                return valLength;
            }

            public DataOutputBuffer getKey() {
                return this.rawKey;
            }

            private void close() throws IOException {
                this.in.close();
                this.in = null;
            }

            public void cleanup() throws IOException {
                this.close();
                if (!this.preserveInput) {
                    Sorter.this.fs.delete(this.segmentPathName, true);
                }
            }
        }

        private class MergeQueue
        extends PriorityQueue
        implements RawKeyValueIterator {
            private boolean compress;
            private boolean blockCompress;
            private DataOutputBuffer rawKey = new DataOutputBuffer();
            private ValueBytes rawValue;
            private long totalBytesProcessed;
            private float progPerByte;
            private Progress mergeProgress = new Progress();
            private Path tmpDir;
            private Progressable progress = null;
            private SegmentDescriptor minSegment;
            private Map<SegmentDescriptor, Void> sortedSegmentSizes = new TreeMap<SegmentDescriptor, Void>();

            public void put(SegmentDescriptor stream) throws IOException {
                if (this.size() == 0) {
                    this.compress = stream.in.isCompressed();
                    this.blockCompress = stream.in.isBlockCompressed();
                } else if (this.compress != stream.in.isCompressed() || this.blockCompress != stream.in.isBlockCompressed()) {
                    throw new IOException("All merged files must be compressed or not.");
                }
                super.put(stream);
            }

            public MergeQueue(List<SegmentDescriptor> segments, Path tmpDir, Progressable progress) {
                int size = segments.size();
                for (int i = 0; i < size; ++i) {
                    this.sortedSegmentSizes.put(segments.get(i), null);
                }
                this.tmpDir = tmpDir;
                this.progress = progress;
            }

            @Override
            protected boolean lessThan(Object a, Object b) {
                if (this.progress != null) {
                    this.progress.progress();
                }
                SegmentDescriptor msa = (SegmentDescriptor)a;
                SegmentDescriptor msb = (SegmentDescriptor)b;
                return Sorter.this.comparator.compare(msa.getKey().getData(), 0, msa.getKey().getLength(), msb.getKey().getData(), 0, msb.getKey().getLength()) < 0;
            }

            @Override
            public void close() throws IOException {
                SegmentDescriptor ms;
                while ((ms = (SegmentDescriptor)this.pop()) != null) {
                    ms.cleanup();
                }
                this.minSegment = null;
            }

            @Override
            public DataOutputBuffer getKey() throws IOException {
                return this.rawKey;
            }

            @Override
            public ValueBytes getValue() throws IOException {
                return this.rawValue;
            }

            @Override
            public boolean next() throws IOException {
                if (this.size() == 0) {
                    return false;
                }
                if (this.minSegment != null) {
                    this.adjustPriorityQueue(this.minSegment);
                    if (this.size() == 0) {
                        this.minSegment = null;
                        return false;
                    }
                }
                this.minSegment = (SegmentDescriptor)this.top();
                long startPos = this.minSegment.in.getPosition();
                this.rawKey = this.minSegment.getKey();
                if (this.rawValue == null) {
                    this.rawValue = this.minSegment.in.createValueBytes();
                }
                this.minSegment.nextRawValue(this.rawValue);
                long endPos = this.minSegment.in.getPosition();
                this.updateProgress(endPos - startPos);
                return true;
            }

            @Override
            public Progress getProgress() {
                return this.mergeProgress;
            }

            private void adjustPriorityQueue(SegmentDescriptor ms) throws IOException {
                long startPos = ms.in.getPosition();
                boolean hasNext = ms.nextRawKey();
                long endPos = ms.in.getPosition();
                this.updateProgress(endPos - startPos);
                if (hasNext) {
                    this.adjustTop();
                } else {
                    this.pop();
                    ms.cleanup();
                }
            }

            private void updateProgress(long bytesProcessed) {
                this.totalBytesProcessed += bytesProcessed;
                if (this.progPerByte > 0.0f) {
                    this.mergeProgress.set((float)this.totalBytesProcessed * this.progPerByte);
                }
            }

            public RawKeyValueIterator merge() throws IOException {
                int numSegments = this.sortedSegmentSizes.size();
                int origFactor = Sorter.this.factor;
                int passNo = 1;
                LocalDirAllocator lDirAlloc = new LocalDirAllocator("io.seqfile.local.dir");
                while (true) {
                    Sorter.this.factor = this.getPassFactor(passNo, numSegments);
                    ArrayList<SegmentDescriptor> segmentsToMerge = new ArrayList<SegmentDescriptor>();
                    int segmentsConsidered = 0;
                    int numSegmentsToConsider = Sorter.this.factor;
                    while (true) {
                        SegmentDescriptor[] mStream = this.getSegmentDescriptors(numSegmentsToConsider);
                        for (int i = 0; i < mStream.length; ++i) {
                            if (mStream[i].nextRawKey()) {
                                segmentsToMerge.add(mStream[i]);
                                ++segmentsConsidered;
                                this.updateProgress(mStream[i].in.getPosition());
                                continue;
                            }
                            mStream[i].cleanup();
                            --numSegments;
                        }
                        if (segmentsConsidered == Sorter.this.factor || this.sortedSegmentSizes.size() == 0) break;
                        numSegmentsToConsider = Sorter.this.factor - segmentsConsidered;
                    }
                    this.initialize(segmentsToMerge.size());
                    this.clear();
                    for (int i = 0; i < segmentsToMerge.size(); ++i) {
                        this.put((SegmentDescriptor)segmentsToMerge.get(i));
                    }
                    if (numSegments <= Sorter.this.factor) {
                        long totalBytes = 0L;
                        for (int i = 0; i < segmentsToMerge.size(); ++i) {
                            totalBytes += ((SegmentDescriptor)segmentsToMerge.get((int)i)).segmentLength;
                        }
                        if (totalBytes != 0L) {
                            this.progPerByte = 1.0f / (float)totalBytes;
                        }
                        Sorter.this.factor = origFactor;
                        return this;
                    }
                    long approxOutputSize = 0L;
                    for (SegmentDescriptor s2 : segmentsToMerge) {
                        approxOutputSize = (long)((double)approxOutputSize + ((double)s2.segmentLength + ChecksumFileSystem.getApproxChkSumLength(s2.segmentLength)));
                    }
                    Path tmpFilename = new Path(this.tmpDir, "intermediate").suffix("." + passNo);
                    Path outputFile = lDirAlloc.getLocalPathForWrite(tmpFilename.toString(), approxOutputSize, Sorter.this.conf);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("writing intermediate results to " + outputFile);
                    }
                    Writer writer = Sorter.this.cloneFileAttributes(Sorter.this.fs.makeQualified(((SegmentDescriptor)segmentsToMerge.get((int)0)).segmentPathName), Sorter.this.fs.makeQualified(outputFile), null);
                    writer.sync = null;
                    Sorter.this.writeFile(this, writer);
                    writer.close();
                    this.close();
                    SegmentDescriptor tempSegment = new SegmentDescriptor(0L, Sorter.this.fs.getFileStatus(outputFile).getLen(), outputFile);
                    this.sortedSegmentSizes.put(tempSegment, null);
                    numSegments = this.sortedSegmentSizes.size();
                    ++passNo;
                    Sorter.this.factor = origFactor;
                }
            }

            public int getPassFactor(int passNo, int numSegments) {
                if (passNo > 1 || numSegments <= Sorter.this.factor || Sorter.this.factor == 1) {
                    return Sorter.this.factor;
                }
                int mod = (numSegments - 1) % (Sorter.this.factor - 1);
                if (mod == 0) {
                    return Sorter.this.factor;
                }
                return mod + 1;
            }

            public SegmentDescriptor[] getSegmentDescriptors(int numDescriptors) {
                if (numDescriptors > this.sortedSegmentSizes.size()) {
                    numDescriptors = this.sortedSegmentSizes.size();
                }
                SegmentDescriptor[] SegmentDescriptors = new SegmentDescriptor[numDescriptors];
                Iterator<SegmentDescriptor> iter = this.sortedSegmentSizes.keySet().iterator();
                int i = 0;
                while (i < numDescriptors) {
                    SegmentDescriptors[i++] = iter.next();
                    iter.remove();
                }
                return SegmentDescriptors;
            }
        }

        public static interface RawKeyValueIterator {
            public DataOutputBuffer getKey() throws IOException;

            public ValueBytes getValue() throws IOException;

            public boolean next() throws IOException;

            public void close() throws IOException;

            public Progress getProgress();
        }

        private class SortPass {
            private int memoryLimit;
            private int recordLimit;
            private DataOutputBuffer rawKeys;
            private byte[] rawBuffer;
            private int[] keyOffsets;
            private int[] pointers;
            private int[] pointersCopy;
            private int[] keyLengths;
            private ValueBytes[] rawValues;
            private ArrayList segmentLengths;
            private Reader in;
            private FSDataOutputStream out;
            private FSDataOutputStream indexOut;
            private Path outName;
            private Progressable progressable;

            private SortPass() {
                this.memoryLimit = Sorter.this.memory / 4;
                this.recordLimit = 1000000;
                this.rawKeys = new DataOutputBuffer();
                this.keyOffsets = new int[1024];
                this.pointers = new int[this.keyOffsets.length];
                this.pointersCopy = new int[this.keyOffsets.length];
                this.keyLengths = new int[this.keyOffsets.length];
                this.rawValues = new ValueBytes[this.keyOffsets.length];
                this.segmentLengths = new ArrayList();
                this.in = null;
                this.out = null;
                this.indexOut = null;
                this.progressable = null;
            }

            public int run(boolean deleteInput) throws IOException {
                int segments = 0;
                int currentFile = 0;
                boolean atEof = currentFile >= Sorter.this.inFiles.length;
                CompressionCodec codec = null;
                this.segmentLengths.clear();
                if (atEof) {
                    return 0;
                }
                this.in = new Reader(Sorter.this.fs, Sorter.this.inFiles[currentFile], Sorter.this.conf);
                CompressionType compressionType = this.in.getCompressionType();
                codec = this.in.getCompressionCodec();
                for (int i = 0; i < this.rawValues.length; ++i) {
                    this.rawValues[i] = null;
                }
                while (!atEof) {
                    int count = 0;
                    int bytesProcessed = 0;
                    this.rawKeys.reset();
                    while (!atEof && bytesProcessed < this.memoryLimit && count < this.recordLimit) {
                        int keyOffset = this.rawKeys.getLength();
                        ValueBytes rawValue = count == this.keyOffsets.length || this.rawValues[count] == null ? this.in.createValueBytes() : this.rawValues[count];
                        int recordLength = this.in.nextRaw(this.rawKeys, rawValue);
                        if (recordLength == -1) {
                            this.in.close();
                            if (deleteInput) {
                                Sorter.this.fs.delete(Sorter.this.inFiles[currentFile], true);
                            }
                            boolean bl = atEof = ++currentFile >= Sorter.this.inFiles.length;
                            if (!atEof) {
                                this.in = new Reader(Sorter.this.fs, Sorter.this.inFiles[currentFile], Sorter.this.conf);
                                continue;
                            }
                            this.in = null;
                            continue;
                        }
                        int keyLength = this.rawKeys.getLength() - keyOffset;
                        if (count == this.keyOffsets.length) {
                            this.grow();
                        }
                        this.keyOffsets[count] = keyOffset;
                        this.pointers[count] = count;
                        this.keyLengths[count] = keyLength;
                        this.rawValues[count] = rawValue;
                        bytesProcessed += recordLength;
                        ++count;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("flushing segment " + segments);
                    }
                    this.rawBuffer = this.rawKeys.getData();
                    this.sort(count);
                    if (this.progressable != null) {
                        this.progressable.progress();
                    }
                    this.flush(count, bytesProcessed, compressionType, codec, segments == 0 && atEof);
                    ++segments;
                }
                return segments;
            }

            public void close() throws IOException {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                if (this.indexOut != null) {
                    this.indexOut.close();
                }
            }

            private void grow() {
                int newLength = this.keyOffsets.length * 3 / 2;
                this.keyOffsets = this.grow(this.keyOffsets, newLength);
                this.pointers = this.grow(this.pointers, newLength);
                this.pointersCopy = new int[newLength];
                this.keyLengths = this.grow(this.keyLengths, newLength);
                this.rawValues = this.grow(this.rawValues, newLength);
            }

            private int[] grow(int[] old, int newLength) {
                int[] result = new int[newLength];
                System.arraycopy(old, 0, result, 0, old.length);
                return result;
            }

            private ValueBytes[] grow(ValueBytes[] old, int newLength) {
                ValueBytes[] result = new ValueBytes[newLength];
                System.arraycopy(old, 0, result, 0, old.length);
                for (int i = old.length; i < newLength; ++i) {
                    result[i] = null;
                }
                return result;
            }

            private void flush(int count, int bytesProcessed, CompressionType compressionType, CompressionCodec codec, boolean done) throws IOException {
                if (this.out == null) {
                    this.outName = done ? Sorter.this.outFile : Sorter.this.outFile.suffix(".0");
                    this.out = Sorter.this.fs.create(this.outName);
                    if (!done) {
                        this.indexOut = Sorter.this.fs.create(this.outName.suffix(".index"));
                    }
                }
                long segmentStart = this.out.getPos();
                Writer writer = SequenceFile.createWriter(Sorter.this.conf, Writer.stream(this.out), Writer.keyClass(Sorter.this.keyClass), Writer.valueClass(Sorter.this.valClass), Writer.compression(compressionType, codec), Writer.metadata(done ? Sorter.this.metadata : new Metadata()));
                if (!done) {
                    writer.sync = null;
                }
                for (int i = 0; i < count; ++i) {
                    int p = this.pointers[i];
                    writer.appendRaw(this.rawBuffer, this.keyOffsets[p], this.keyLengths[p], this.rawValues[p]);
                }
                writer.close();
                if (!done) {
                    WritableUtils.writeVLong(this.indexOut, segmentStart);
                    WritableUtils.writeVLong(this.indexOut, this.out.getPos() - segmentStart);
                    this.indexOut.flush();
                }
            }

            private void sort(int count) {
                System.arraycopy(this.pointers, 0, this.pointersCopy, 0, count);
                Sorter.this.mergeSort.mergeSort(this.pointersCopy, this.pointers, 0, count);
            }

            public void setProgressable(Progressable progressable) {
                this.progressable = progressable;
            }

            class SeqFileComparator
            implements Comparator<IntWritable> {
                SeqFileComparator() {
                }

                @Override
                public int compare(IntWritable I, IntWritable J) {
                    return Sorter.this.comparator.compare(SortPass.this.rawBuffer, SortPass.this.keyOffsets[I.get()], SortPass.this.keyLengths[I.get()], SortPass.this.rawBuffer, SortPass.this.keyOffsets[J.get()], SortPass.this.keyLengths[J.get()]);
                }
            }
        }
    }

    public static class Reader
    implements Closeable {
        private String filename;
        private FSDataInputStream in;
        private DataOutputBuffer outBuf = new DataOutputBuffer();
        private byte version;
        private String keyClassName;
        private String valClassName;
        private Class keyClass;
        private Class valClass;
        private CompressionCodec codec = null;
        private Metadata metadata = null;
        private byte[] sync = new byte[16];
        private byte[] syncCheck = new byte[16];
        private boolean syncSeen;
        private long headerEnd;
        private long end;
        private int keyLength;
        private int recordLength;
        private boolean decompress;
        private boolean blockCompressed;
        private Configuration conf;
        private int noBufferedRecords = 0;
        private boolean lazyDecompress = true;
        private boolean valuesDecompressed = true;
        private int noBufferedKeys = 0;
        private int noBufferedValues = 0;
        private DataInputBuffer keyLenBuffer = null;
        private CompressionInputStream keyLenInFilter = null;
        private DataInputStream keyLenIn = null;
        private Decompressor keyLenDecompressor = null;
        private DataInputBuffer keyBuffer = null;
        private CompressionInputStream keyInFilter = null;
        private DataInputStream keyIn = null;
        private Decompressor keyDecompressor = null;
        private DataInputBuffer valLenBuffer = null;
        private CompressionInputStream valLenInFilter = null;
        private DataInputStream valLenIn = null;
        private Decompressor valLenDecompressor = null;
        private DataInputBuffer valBuffer = null;
        private CompressionInputStream valInFilter = null;
        private DataInputStream valIn = null;
        private Decompressor valDecompressor = null;
        private Deserializer keyDeserializer;
        private Deserializer valDeserializer;

        public static Option file(Path value) {
            return new FileOption(value);
        }

        public static Option stream(FSDataInputStream value) {
            return new InputStreamOption(value);
        }

        public static Option start(long value) {
            return new StartOption(value);
        }

        public static Option length(long value) {
            return new LengthOption(value);
        }

        public static Option bufferSize(int value) {
            return new BufferSizeOption(value);
        }

        public Reader(Configuration conf, Option ... opts) throws IOException {
            FSDataInputStream file;
            long len;
            FileOption fileOpt = Options.getOption(FileOption.class, opts);
            InputStreamOption streamOpt = Options.getOption(InputStreamOption.class, opts);
            StartOption startOpt = Options.getOption(StartOption.class, opts);
            LengthOption lenOpt = Options.getOption(LengthOption.class, opts);
            BufferSizeOption bufOpt = Options.getOption(BufferSizeOption.class, opts);
            OnlyHeaderOption headerOnly = Options.getOption(OnlyHeaderOption.class, opts);
            if (fileOpt == null == (streamOpt == null)) {
                throw new IllegalArgumentException("File or stream option must be specified");
            }
            if (fileOpt == null && bufOpt != null) {
                throw new IllegalArgumentException("buffer size can only be set when a file is specified.");
            }
            Path filename = null;
            if (fileOpt != null) {
                filename = fileOpt.getValue();
                FileSystem fs = filename.getFileSystem(conf);
                int bufSize = bufOpt == null ? SequenceFile.getBufferSize(conf) : bufOpt.getValue();
                len = null == lenOpt ? fs.getFileStatus(filename).getLen() : lenOpt.getValue();
                file = this.openFile(fs, filename, bufSize, len);
            } else {
                len = null == lenOpt ? Long.MAX_VALUE : lenOpt.getValue();
                file = streamOpt.getValue();
            }
            long start = startOpt == null ? 0L : startOpt.getValue();
            this.initialize(filename, file, start, len, conf, headerOnly != null);
        }

        @Deprecated
        public Reader(FileSystem fs, Path file, Configuration conf) throws IOException {
            this(conf, Reader.file(fs.makeQualified(file)));
        }

        @Deprecated
        public Reader(FSDataInputStream in, int buffersize, long start, long length, Configuration conf) throws IOException {
            this(conf, Reader.stream(in), Reader.start(start), Reader.length(length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void initialize(Path filename, FSDataInputStream in, long start, long length, Configuration conf, boolean tempReader) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException("in == null");
            }
            this.filename = filename == null ? "<unknown>" : filename.toString();
            this.in = in;
            this.conf = conf;
            boolean succeeded = false;
            try {
                this.seek(start);
                this.end = this.in.getPos() + length;
                if (this.end < length) {
                    this.end = Long.MAX_VALUE;
                }
                this.init(tempReader);
                return;
            }
            catch (Throwable throwable) {
                if (succeeded) throw throwable;
                IOUtils.cleanupWithLogger(LOG, this.in);
                throw throwable;
            }
        }

        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return fs.open(file, bufferSize);
        }

        private void init(boolean tempReader) throws IOException {
            byte[] versionBlock = new byte[VERSION.length];
            String exceptionMsg = this + " not a SequenceFile";
            try {
                this.in.readFully(versionBlock);
            }
            catch (EOFException e) {
                throw new EOFException(exceptionMsg);
            }
            if (versionBlock[0] != VERSION[0] || versionBlock[1] != VERSION[1] || versionBlock[2] != VERSION[2]) {
                throw new IOException(this + " not a SequenceFile");
            }
            this.version = versionBlock[3];
            if (this.version > VERSION[3]) {
                throw new VersionMismatchException(VERSION[3], this.version);
            }
            if (this.version < 4) {
                UTF8 className = new UTF8();
                className.readFields(this.in);
                this.keyClassName = className.toStringChecked();
                className.readFields(this.in);
                this.valClassName = className.toStringChecked();
            } else {
                this.keyClassName = Text.readString(this.in);
                this.valClassName = Text.readString(this.in);
            }
            this.decompress = this.version > 2 ? this.in.readBoolean() : false;
            this.blockCompressed = this.version >= 4 ? this.in.readBoolean() : false;
            if (this.decompress) {
                if (this.version >= 5) {
                    String codecClassname = Text.readString(this.in);
                    try {
                        Class<CompressionCodec> codecClass = this.conf.getClassByName(codecClassname).asSubclass(CompressionCodec.class);
                        this.codec = ReflectionUtils.newInstance(codecClass, this.conf);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IllegalArgumentException("Unknown codec: " + codecClassname, cnfe);
                    }
                } else {
                    this.codec = new DefaultCodec();
                    ((Configurable)((Object)this.codec)).setConf(this.conf);
                }
            }
            this.metadata = new Metadata();
            if (this.version >= 6) {
                this.metadata.readFields(this.in);
            }
            if (this.version > 1) {
                this.in.readFully(this.sync);
                this.headerEnd = this.in.getPos();
            }
            if (!tempReader) {
                this.valBuffer = new DataInputBuffer();
                if (this.decompress) {
                    this.valDecompressor = CodecPool.getDecompressor(this.codec);
                    this.valInFilter = this.codec.createInputStream(this.valBuffer, this.valDecompressor);
                    this.valIn = new DataInputStream(this.valInFilter);
                } else {
                    this.valIn = this.valBuffer;
                }
                if (this.blockCompressed) {
                    this.keyLenBuffer = new DataInputBuffer();
                    this.keyBuffer = new DataInputBuffer();
                    this.valLenBuffer = new DataInputBuffer();
                    this.keyLenDecompressor = CodecPool.getDecompressor(this.codec);
                    this.keyLenInFilter = this.codec.createInputStream(this.keyLenBuffer, this.keyLenDecompressor);
                    this.keyLenIn = new DataInputStream(this.keyLenInFilter);
                    this.keyDecompressor = CodecPool.getDecompressor(this.codec);
                    this.keyInFilter = this.codec.createInputStream(this.keyBuffer, this.keyDecompressor);
                    this.keyIn = new DataInputStream(this.keyInFilter);
                    this.valLenDecompressor = CodecPool.getDecompressor(this.codec);
                    this.valLenInFilter = this.codec.createInputStream(this.valLenBuffer, this.valLenDecompressor);
                    this.valLenIn = new DataInputStream(this.valLenInFilter);
                }
                SerializationFactory serializationFactory = new SerializationFactory(this.conf);
                this.keyDeserializer = this.getDeserializer(serializationFactory, this.getKeyClass());
                if (this.keyDeserializer == null) {
                    throw new IOException("Could not find a deserializer for the Key class: '" + this.getKeyClass().getCanonicalName() + "'. Please ensure that the configuration '" + "io.serializations" + "' is properly configured, if you're using custom serialization.");
                }
                if (!this.blockCompressed) {
                    this.keyDeserializer.open(this.valBuffer);
                } else {
                    this.keyDeserializer.open(this.keyIn);
                }
                this.valDeserializer = this.getDeserializer(serializationFactory, this.getValueClass());
                if (this.valDeserializer == null) {
                    throw new IOException("Could not find a deserializer for the Value class: '" + this.getValueClass().getCanonicalName() + "'. Please ensure that the configuration '" + "io.serializations" + "' is properly configured, if you're using custom serialization.");
                }
                this.valDeserializer.open(this.valIn);
            }
        }

        private Deserializer getDeserializer(SerializationFactory sf, Class c) {
            return sf.getDeserializer(c);
        }

        @Override
        public synchronized void close() throws IOException {
            CodecPool.returnDecompressor(this.keyLenDecompressor);
            CodecPool.returnDecompressor(this.keyDecompressor);
            CodecPool.returnDecompressor(this.valLenDecompressor);
            CodecPool.returnDecompressor(this.valDecompressor);
            this.keyDecompressor = null;
            this.keyLenDecompressor = null;
            this.valDecompressor = null;
            this.valLenDecompressor = null;
            if (this.keyDeserializer != null) {
                this.keyDeserializer.close();
            }
            if (this.valDeserializer != null) {
                this.valDeserializer.close();
            }
            this.in.close();
        }

        public String getKeyClassName() {
            return this.keyClassName;
        }

        public synchronized Class<?> getKeyClass() {
            if (null == this.keyClass) {
                try {
                    this.keyClass = WritableName.getClass(this.getKeyClassName(), this.conf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.keyClass;
        }

        public String getValueClassName() {
            return this.valClassName;
        }

        public synchronized Class<?> getValueClass() {
            if (null == this.valClass) {
                try {
                    this.valClass = WritableName.getClass(this.getValueClassName(), this.conf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.valClass;
        }

        public boolean isCompressed() {
            return this.decompress;
        }

        public boolean isBlockCompressed() {
            return this.blockCompressed;
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        private byte[] getSync() {
            return this.sync;
        }

        private byte getVersion() {
            return this.version;
        }

        public CompressionType getCompressionType() {
            if (this.decompress) {
                return this.blockCompressed ? CompressionType.BLOCK : CompressionType.RECORD;
            }
            return CompressionType.NONE;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        Configuration getConf() {
            return this.conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void readBuffer(DataInputBuffer buffer, CompressionInputStream filter) throws IOException {
            try (DataOutputBuffer dataBuffer = new DataOutputBuffer();){
                int dataBufferLength = WritableUtils.readVInt(this.in);
                dataBuffer.write(this.in, dataBufferLength);
                buffer.reset(dataBuffer.getData(), 0, dataBuffer.getLength());
            }
            filter.resetState();
        }

        private synchronized void readBlock() throws IOException {
            if (this.lazyDecompress && !this.valuesDecompressed) {
                this.in.seek((long)WritableUtils.readVInt(this.in) + this.in.getPos());
                this.in.seek((long)WritableUtils.readVInt(this.in) + this.in.getPos());
            }
            this.noBufferedKeys = 0;
            this.noBufferedValues = 0;
            this.noBufferedRecords = 0;
            this.valuesDecompressed = false;
            if (this.sync != null) {
                this.in.readInt();
                this.in.readFully(this.syncCheck);
                if (!Arrays.equals(this.sync, this.syncCheck)) {
                    throw new IOException("File is corrupt!");
                }
            }
            this.syncSeen = true;
            this.noBufferedRecords = WritableUtils.readVInt(this.in);
            this.readBuffer(this.keyLenBuffer, this.keyLenInFilter);
            this.readBuffer(this.keyBuffer, this.keyInFilter);
            this.noBufferedKeys = this.noBufferedRecords;
            if (!this.lazyDecompress) {
                this.readBuffer(this.valLenBuffer, this.valLenInFilter);
                this.readBuffer(this.valBuffer, this.valInFilter);
                this.noBufferedValues = this.noBufferedRecords;
                this.valuesDecompressed = true;
            }
        }

        private synchronized void seekToCurrentValue() throws IOException {
            if (!this.blockCompressed) {
                if (this.decompress) {
                    this.valInFilter.resetState();
                }
                this.valBuffer.reset();
            } else {
                if (this.lazyDecompress && !this.valuesDecompressed) {
                    this.readBuffer(this.valLenBuffer, this.valLenInFilter);
                    this.readBuffer(this.valBuffer, this.valInFilter);
                    this.noBufferedValues = this.noBufferedRecords;
                    this.valuesDecompressed = true;
                }
                int skipValBytes = 0;
                int currentKey = this.noBufferedKeys + 1;
                for (int i = this.noBufferedValues; i > currentKey; --i) {
                    skipValBytes += WritableUtils.readVInt(this.valLenIn);
                    --this.noBufferedValues;
                }
                if (skipValBytes > 0 && this.valIn.skipBytes(skipValBytes) != skipValBytes) {
                    throw new IOException("Failed to seek to " + currentKey + "(th) value!");
                }
            }
        }

        public synchronized void getCurrentValue(Writable val) throws IOException {
            if (val instanceof Configurable) {
                ((Configurable)((Object)val)).setConf(this.conf);
            }
            this.seekToCurrentValue();
            if (!this.blockCompressed) {
                val.readFields(this.valIn);
                if (this.valIn.read() > 0) {
                    LOG.info("available bytes: " + this.valIn.available());
                    throw new IOException(val + " read " + (this.valBuffer.getPosition() - this.keyLength) + " bytes, should read " + (this.valBuffer.getLength() - this.keyLength));
                }
            } else {
                int valLength = WritableUtils.readVInt(this.valLenIn);
                val.readFields(this.valIn);
                --this.noBufferedValues;
                if (valLength < 0 && LOG.isDebugEnabled()) {
                    LOG.debug(val + " is a zero-length value");
                }
            }
        }

        public synchronized Object getCurrentValue(Object val) throws IOException {
            if (val instanceof Configurable) {
                ((Configurable)val).setConf(this.conf);
            }
            this.seekToCurrentValue();
            if (!this.blockCompressed) {
                val = this.deserializeValue(val);
                if (this.valIn.read() > 0) {
                    LOG.info("available bytes: " + this.valIn.available());
                    throw new IOException(val + " read " + (this.valBuffer.getPosition() - this.keyLength) + " bytes, should read " + (this.valBuffer.getLength() - this.keyLength));
                }
            } else {
                int valLength = WritableUtils.readVInt(this.valLenIn);
                val = this.deserializeValue(val);
                --this.noBufferedValues;
                if (valLength < 0 && LOG.isDebugEnabled()) {
                    LOG.debug(val + " is a zero-length value");
                }
            }
            return val;
        }

        private Object deserializeValue(Object val) throws IOException {
            return this.valDeserializer.deserialize(val);
        }

        public synchronized boolean next(Writable key) throws IOException {
            if (key.getClass() != this.getKeyClass()) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (!this.blockCompressed) {
                this.outBuf.reset();
                this.keyLength = this.next(this.outBuf);
                if (this.keyLength < 0) {
                    return false;
                }
                this.valBuffer.reset(this.outBuf.getData(), this.outBuf.getLength());
                key.readFields(this.valBuffer);
                this.valBuffer.mark(0);
                if (this.valBuffer.getPosition() != this.keyLength) {
                    throw new IOException(key + " read " + this.valBuffer.getPosition() + " bytes, should read " + this.keyLength);
                }
            } else {
                int keyLength;
                this.syncSeen = false;
                if (this.noBufferedKeys == 0) {
                    try {
                        this.readBlock();
                    }
                    catch (EOFException eof) {
                        return false;
                    }
                }
                if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                    return false;
                }
                key.readFields(this.keyIn);
                --this.noBufferedKeys;
            }
            return true;
        }

        public synchronized boolean next(Writable key, Writable val) throws IOException {
            if (val.getClass() != this.getValueClass()) {
                throw new IOException("wrong value class: " + val + " is not " + this.valClass);
            }
            boolean more = this.next(key);
            if (more) {
                this.getCurrentValue(val);
            }
            return more;
        }

        private synchronized int readRecordLength() throws IOException {
            if (this.in.getPos() >= this.end) {
                return -1;
            }
            int length = this.in.readInt();
            if (this.version > 1 && this.sync != null && length == -1) {
                this.in.readFully(this.syncCheck);
                if (!Arrays.equals(this.sync, this.syncCheck)) {
                    throw new IOException("File is corrupt!");
                }
                this.syncSeen = true;
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                length = this.in.readInt();
            } else {
                this.syncSeen = false;
            }
            return length;
        }

        @Deprecated
        synchronized int next(DataOutputBuffer buffer) throws IOException {
            if (this.blockCompressed) {
                throw new IOException("Unsupported call for block-compressed SequenceFiles - use SequenceFile.Reader.next(DataOutputStream, ValueBytes)");
            }
            try {
                int length = this.readRecordLength();
                if (length == -1) {
                    return -1;
                }
                int keyLength = this.in.readInt();
                buffer.write(this.in, length);
                return keyLength;
            }
            catch (ChecksumException e) {
                this.handleChecksumException(e);
                return this.next(buffer);
            }
        }

        public ValueBytes createValueBytes() {
            ValueBytes val = null;
            val = !this.decompress || this.blockCompressed ? new UncompressedBytes() : new CompressedBytes(this.codec);
            return val;
        }

        public synchronized int nextRaw(DataOutputBuffer key, ValueBytes val) throws IOException {
            int keyLength;
            if (!this.blockCompressed) {
                int length = this.readRecordLength();
                if (length == -1) {
                    return -1;
                }
                int keyLength2 = this.in.readInt();
                int valLength = length - keyLength2;
                key.write(this.in, keyLength2);
                if (this.decompress) {
                    CompressedBytes value = (CompressedBytes)val;
                    value.reset(this.in, valLength);
                } else {
                    UncompressedBytes value = (UncompressedBytes)val;
                    value.reset(this.in, valLength);
                }
                return length;
            }
            this.syncSeen = false;
            if (this.noBufferedKeys == 0) {
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                try {
                    this.readBlock();
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
            if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                throw new IOException("zero length key found!");
            }
            key.write(this.keyIn, keyLength);
            --this.noBufferedKeys;
            this.seekToCurrentValue();
            int valLength = WritableUtils.readVInt(this.valLenIn);
            UncompressedBytes rawValue = (UncompressedBytes)val;
            rawValue.reset(this.valIn, valLength);
            --this.noBufferedValues;
            return keyLength + valLength;
        }

        public synchronized int nextRawKey(DataOutputBuffer key) throws IOException {
            int keyLength;
            if (!this.blockCompressed) {
                this.recordLength = this.readRecordLength();
                if (this.recordLength == -1) {
                    return -1;
                }
                this.keyLength = this.in.readInt();
                key.write(this.in, this.keyLength);
                return this.keyLength;
            }
            this.syncSeen = false;
            if (this.noBufferedKeys == 0) {
                if (this.in.getPos() >= this.end) {
                    return -1;
                }
                try {
                    this.readBlock();
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
            if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                throw new IOException("zero length key found!");
            }
            key.write(this.keyIn, keyLength);
            --this.noBufferedKeys;
            return keyLength;
        }

        public synchronized Object next(Object key) throws IOException {
            if (key != null && key.getClass() != this.getKeyClass()) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (!this.blockCompressed) {
                this.outBuf.reset();
                this.keyLength = this.next(this.outBuf);
                if (this.keyLength < 0) {
                    return null;
                }
                this.valBuffer.reset(this.outBuf.getData(), this.outBuf.getLength());
                key = this.deserializeKey(key);
                this.valBuffer.mark(0);
                if (this.valBuffer.getPosition() != this.keyLength) {
                    throw new IOException(key + " read " + this.valBuffer.getPosition() + " bytes, should read " + this.keyLength);
                }
            } else {
                int keyLength;
                this.syncSeen = false;
                if (this.noBufferedKeys == 0) {
                    try {
                        this.readBlock();
                    }
                    catch (EOFException eof) {
                        return null;
                    }
                }
                if ((keyLength = WritableUtils.readVInt(this.keyLenIn)) < 0) {
                    return null;
                }
                key = this.deserializeKey(key);
                --this.noBufferedKeys;
            }
            return key;
        }

        private Object deserializeKey(Object key) throws IOException {
            return this.keyDeserializer.deserialize(key);
        }

        public synchronized int nextRawValue(ValueBytes val) throws IOException {
            this.seekToCurrentValue();
            if (!this.blockCompressed) {
                int valLength = this.recordLength - this.keyLength;
                if (this.decompress) {
                    CompressedBytes value = (CompressedBytes)val;
                    value.reset(this.in, valLength);
                } else {
                    UncompressedBytes value = (UncompressedBytes)val;
                    value.reset(this.in, valLength);
                }
                return valLength;
            }
            int valLength = WritableUtils.readVInt(this.valLenIn);
            UncompressedBytes rawValue = (UncompressedBytes)val;
            rawValue.reset(this.valIn, valLength);
            --this.noBufferedValues;
            return valLength;
        }

        private void handleChecksumException(ChecksumException e) throws IOException {
            if (!this.conf.getBoolean("io.skip.checksum.errors", false)) {
                throw e;
            }
            LOG.warn("Bad checksum at " + this.getPosition() + ". Skipping entries.");
            this.sync(this.getPosition() + (long)this.conf.getInt("io.bytes.per.checksum", 512));
        }

        synchronized void ignoreSync() {
            this.sync = null;
        }

        public synchronized void seek(long position) throws IOException {
            this.in.seek(position);
            if (this.blockCompressed) {
                this.noBufferedKeys = 0;
                this.valuesDecompressed = true;
            }
        }

        public synchronized void sync(long position) throws IOException {
            if (position + 20L >= this.end) {
                this.seek(this.end);
                return;
            }
            if (position < this.headerEnd) {
                this.in.seek(this.headerEnd);
                this.syncSeen = true;
                return;
            }
            try {
                this.seek(position + 4L);
                this.in.readFully(this.syncCheck);
                int syncLen = this.sync.length;
                int i = 0;
                while (this.in.getPos() < this.end) {
                    int j;
                    for (j = 0; j < syncLen && this.sync[j] == this.syncCheck[(i + j) % syncLen]; ++j) {
                    }
                    if (j == syncLen) {
                        this.in.seek(this.in.getPos() - 20L);
                        return;
                    }
                    this.syncCheck[i % syncLen] = this.in.readByte();
                    ++i;
                }
            }
            catch (ChecksumException e) {
                this.handleChecksumException(e);
            }
        }

        public synchronized boolean syncSeen() {
            return this.syncSeen;
        }

        public synchronized long getPosition() throws IOException {
            return this.in.getPos();
        }

        public String toString() {
            return this.filename;
        }

        private static class OnlyHeaderOption
        extends Options.BooleanOption
        implements Option {
            private OnlyHeaderOption() {
                super(true);
            }
        }

        private static class BufferSizeOption
        extends Options.IntegerOption
        implements Option {
            private BufferSizeOption(int value) {
                super(value);
            }
        }

        private static class LengthOption
        extends Options.LongOption
        implements Option {
            private LengthOption(long value) {
                super(value);
            }
        }

        private static class StartOption
        extends Options.LongOption
        implements Option {
            private StartOption(long value) {
                super(value);
            }
        }

        private static class InputStreamOption
        extends Options.FSDataInputStreamOption
        implements Option {
            private InputStreamOption(FSDataInputStream value) {
                super(value);
            }
        }

        private static class FileOption
        extends Options.PathOption
        implements Option {
            private FileOption(Path value) {
                super(value);
            }
        }

        public static interface Option {
        }
    }

    static class BlockCompressWriter
    extends Writer {
        private int noBufferedRecords = 0;
        private DataOutputBuffer keyLenBuffer = new DataOutputBuffer();
        private DataOutputBuffer keyBuffer = new DataOutputBuffer();
        private DataOutputBuffer valLenBuffer = new DataOutputBuffer();
        private DataOutputBuffer valBuffer = new DataOutputBuffer();
        private final int compressionBlockSize;

        BlockCompressWriter(Configuration conf, Writer.Option ... options) throws IOException {
            super(conf, options);
            this.compressionBlockSize = conf.getInt("io.seqfile.compress.blocksize", 1000000);
            this.keySerializer.close();
            this.keySerializer.open(this.keyBuffer);
            this.uncompressedValSerializer.close();
            this.uncompressedValSerializer.open(this.valBuffer);
        }

        private synchronized void writeBuffer(DataOutputBuffer uncompressedDataBuffer) throws IOException {
            this.deflateFilter.resetState();
            this.buffer.reset();
            this.deflateOut.write(uncompressedDataBuffer.getData(), 0, uncompressedDataBuffer.getLength());
            this.deflateOut.flush();
            this.deflateFilter.finish();
            WritableUtils.writeVInt(this.out, this.buffer.getLength());
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        @Override
        public synchronized void sync() throws IOException {
            if (this.noBufferedRecords > 0) {
                super.sync();
                WritableUtils.writeVInt(this.out, this.noBufferedRecords);
                this.writeBuffer(this.keyLenBuffer);
                this.writeBuffer(this.keyBuffer);
                this.writeBuffer(this.valLenBuffer);
                this.writeBuffer(this.valBuffer);
                this.out.flush();
                this.keyLenBuffer.reset();
                this.keyBuffer.reset();
                this.valLenBuffer.reset();
                this.valBuffer.reset();
                this.noBufferedRecords = 0;
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.sync();
            }
            super.close();
        }

        @Override
        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val + " is not " + this.valClass);
            }
            int oldKeyLength = this.keyBuffer.getLength();
            this.keySerializer.serialize(key);
            int keyLength = this.keyBuffer.getLength() - oldKeyLength;
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            WritableUtils.writeVInt(this.keyLenBuffer, keyLength);
            int oldValLength = this.valBuffer.getLength();
            this.uncompressedValSerializer.serialize(val);
            int valLength = this.valBuffer.getLength() - oldValLength;
            WritableUtils.writeVInt(this.valLenBuffer, valLength);
            ++this.noBufferedRecords;
            int currentBlockSize = this.keyBuffer.getLength() + this.valBuffer.getLength();
            if (currentBlockSize >= this.compressionBlockSize) {
                this.sync();
            }
        }

        @Override
        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed");
            }
            int valLength = val.getSize();
            WritableUtils.writeVInt(this.keyLenBuffer, keyLength);
            this.keyBuffer.write(keyData, keyOffset, keyLength);
            WritableUtils.writeVInt(this.valLenBuffer, valLength);
            val.writeUncompressedBytes(this.valBuffer);
            ++this.noBufferedRecords;
            int currentBlockSize = this.keyBuffer.getLength() + this.valBuffer.getLength();
            if (currentBlockSize >= this.compressionBlockSize) {
                this.sync();
            }
        }
    }

    static class RecordCompressWriter
    extends Writer {
        RecordCompressWriter(Configuration conf, Writer.Option ... options) throws IOException {
            super(conf, options);
        }

        @Override
        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val.getClass().getName() + " is not " + this.valClass);
            }
            this.buffer.reset();
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            this.deflateFilter.resetState();
            this.compressedValSerializer.serialize(val);
            this.deflateOut.flush();
            this.deflateFilter.finish();
            this.checkAndWriteSync();
            this.out.writeInt(this.buffer.getLength());
            this.out.writeInt(keyLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        @Override
        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + keyLength);
            }
            int valLength = val.getSize();
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valLength);
            this.out.writeInt(keyLength);
            this.out.write(keyData, keyOffset, keyLength);
            val.writeCompressedBytes(this.out);
        }
    }

    public static class Writer
    implements Closeable,
    Syncable,
    Flushable,
    StreamCapabilities {
        private Configuration conf;
        FSDataOutputStream out;
        boolean ownOutputStream = true;
        DataOutputBuffer buffer = new DataOutputBuffer();
        Class keyClass;
        Class valClass;
        private final CompressionType compress;
        CompressionCodec codec = null;
        CompressionOutputStream deflateFilter = null;
        DataOutputStream deflateOut = null;
        Metadata metadata = null;
        Compressor compressor = null;
        private boolean appendMode = false;
        protected Serializer keySerializer;
        protected Serializer uncompressedValSerializer;
        protected Serializer compressedValSerializer;
        long lastSyncPos;
        byte[] sync;
        @VisibleForTesting
        int syncInterval;

        public static Option file(Path value) {
            return new FileOption(value);
        }

        @Deprecated
        private static Option filesystem(FileSystem fs) {
            return new FileSystemOption(fs);
        }

        public static Option bufferSize(int value) {
            return new BufferSizeOption(value);
        }

        public static Option stream(FSDataOutputStream value) {
            return new StreamOption(value);
        }

        public static Option replication(short value) {
            return new ReplicationOption(value);
        }

        public static Option appendIfExists(boolean value) {
            return new AppendIfExistsOption(value);
        }

        public static Option blockSize(long value) {
            return new BlockSizeOption(value);
        }

        public static Option progressable(Progressable value) {
            return new ProgressableOption(value);
        }

        public static Option keyClass(Class<?> value) {
            return new KeyClassOption(value);
        }

        public static Option valueClass(Class<?> value) {
            return new ValueClassOption(value);
        }

        public static Option metadata(Metadata value) {
            return new MetadataOption(value);
        }

        public static Option compression(CompressionType value) {
            return new CompressionOption(value);
        }

        public static Option compression(CompressionType value, CompressionCodec codec) {
            return new CompressionOption(value, codec);
        }

        public static Option syncInterval(int value) {
            return new SyncIntervalOption(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Writer(Configuration conf, Option ... opts) throws IOException {
            FSDataOutputStream out;
            boolean ownStream;
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes(StandardCharsets.UTF_8));
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            BlockSizeOption blockSizeOption = Options.getOption(BlockSizeOption.class, opts);
            BufferSizeOption bufferSizeOption = Options.getOption(BufferSizeOption.class, opts);
            ReplicationOption replicationOption = Options.getOption(ReplicationOption.class, opts);
            ProgressableOption progressOption = Options.getOption(ProgressableOption.class, opts);
            FileOption fileOption = Options.getOption(FileOption.class, opts);
            AppendIfExistsOption appendIfExistsOption = Options.getOption(AppendIfExistsOption.class, opts);
            FileSystemOption fsOption = Options.getOption(FileSystemOption.class, opts);
            StreamOption streamOption = Options.getOption(StreamOption.class, opts);
            KeyClassOption keyClassOption = Options.getOption(KeyClassOption.class, opts);
            ValueClassOption valueClassOption = Options.getOption(ValueClassOption.class, opts);
            MetadataOption metadataOption = Options.getOption(MetadataOption.class, opts);
            CompressionOption compressionTypeOption = Options.getOption(CompressionOption.class, opts);
            SyncIntervalOption syncIntervalOption = Options.getOption(SyncIntervalOption.class, opts);
            if (fileOption == null == (streamOption == null)) {
                throw new IllegalArgumentException("file or stream must be specified");
            }
            if (fileOption == null && (blockSizeOption != null || bufferSizeOption != null || replicationOption != null || progressOption != null)) {
                throw new IllegalArgumentException("file modifier options not compatible with stream");
            }
            boolean bl = ownStream = fileOption != null;
            if (ownStream) {
                Progressable progress;
                Path p = fileOption.getValue();
                FileSystem fs = fsOption != null ? fsOption.getValue() : p.getFileSystem(conf);
                int bufferSize = bufferSizeOption == null ? SequenceFile.getBufferSize(conf) : bufferSizeOption.getValue();
                short replication = replicationOption == null ? fs.getDefaultReplication(p) : (short)replicationOption.getValue();
                long blockSize = blockSizeOption == null ? fs.getDefaultBlockSize(p) : blockSizeOption.getValue();
                Progressable progressable = progress = progressOption == null ? null : progressOption.getValue();
                if (appendIfExistsOption != null && appendIfExistsOption.getValue() && fs.exists(p)) {
                    try (Reader reader = new Reader(conf, Reader.file(p), new Reader.OnlyHeaderOption());){
                        if (keyClassOption.getValue() != reader.getKeyClass() || valueClassOption.getValue() != reader.getValueClass()) {
                            throw new IllegalArgumentException("Key/value class provided does not match the file");
                        }
                        if (reader.getVersion() != VERSION[3]) {
                            throw new VersionMismatchException(VERSION[3], reader.getVersion());
                        }
                        if (metadataOption != null) {
                            LOG.info("MetaData Option is ignored during append");
                        }
                        metadataOption = (MetadataOption)Writer.metadata(reader.getMetadata());
                        CompressionOption readerCompressionOption = new CompressionOption(reader.getCompressionType(), reader.getCompressionCodec());
                        if (readerCompressionOption.value != compressionTypeOption.value || readerCompressionOption.value != CompressionType.NONE && readerCompressionOption.codec.getClass() != compressionTypeOption.codec.getClass()) {
                            throw new IllegalArgumentException("Compression option provided does not match the file");
                        }
                        this.sync = reader.getSync();
                    }
                    out = fs.append(p, bufferSize, progress);
                    this.appendMode = true;
                } else {
                    out = fs.create(p, true, bufferSize, replication, blockSize, progress);
                }
            } else {
                out = streamOption.getValue();
            }
            Class keyClass = keyClassOption == null ? Object.class : keyClassOption.getValue();
            Class valueClass = valueClassOption == null ? Object.class : valueClassOption.getValue();
            Metadata metadata = metadataOption == null ? new Metadata() : metadataOption.getValue();
            this.compress = compressionTypeOption.getValue();
            CompressionCodec codec = compressionTypeOption.getCodec();
            if (codec != null && codec instanceof GzipCodec && !NativeCodeLoader.isNativeCodeLoaded() && !ZlibFactory.isNativeZlibLoaded(conf)) {
                throw new IllegalArgumentException("SequenceFile doesn't work with GzipCodec without native-hadoop code!");
            }
            this.syncInterval = syncIntervalOption == null ? 102400 : syncIntervalOption.getValue();
            this.init(conf, out, ownStream, keyClass, valueClass, codec, metadata, this.syncInterval);
        }

        @Deprecated
        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes(StandardCharsets.UTF_8));
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.compress = CompressionType.NONE;
            this.init(conf, fs.create(name), true, keyClass, valClass, null, new Metadata(), 102400);
        }

        @Deprecated
        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, Progressable progress, Metadata metadata) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes(StandardCharsets.UTF_8));
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.compress = CompressionType.NONE;
            this.init(conf, fs.create(name, progress), true, keyClass, valClass, null, metadata, 102400);
        }

        @Deprecated
        public Writer(FileSystem fs, Configuration conf, Path name, Class keyClass, Class valClass, int bufferSize, short replication, long blockSize, Progressable progress, Metadata metadata) throws IOException {
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                long time = Time.now();
                digester.update((new UID() + "@" + time).getBytes(StandardCharsets.UTF_8));
                this.sync = digester.digest();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.compress = CompressionType.NONE;
            this.init(conf, fs.create(name, true, bufferSize, replication, blockSize, progress), true, keyClass, valClass, null, metadata, 102400);
        }

        boolean isCompressed() {
            return this.compress != CompressionType.NONE;
        }

        boolean isBlockCompressed() {
            return this.compress == CompressionType.BLOCK;
        }

        Writer ownStream() {
            this.ownOutputStream = true;
            return this;
        }

        private void writeFileHeader() throws IOException {
            this.out.write(VERSION);
            Text.writeString(this.out, this.keyClass.getName());
            Text.writeString(this.out, this.valClass.getName());
            this.out.writeBoolean(this.isCompressed());
            this.out.writeBoolean(this.isBlockCompressed());
            if (this.isCompressed()) {
                Text.writeString(this.out, this.codec.getClass().getName());
            }
            this.metadata.write(this.out);
            this.out.write(this.sync);
            this.out.flush();
        }

        void init(Configuration config, FSDataOutputStream outStream, boolean ownStream, Class key, Class val, CompressionCodec compCodec, Metadata meta, int syncIntervalVal) throws IOException {
            this.conf = config;
            this.out = outStream;
            this.ownOutputStream = ownStream;
            this.keyClass = key;
            this.valClass = val;
            this.codec = compCodec;
            this.metadata = meta;
            this.syncInterval = syncIntervalVal;
            SerializationFactory serializationFactory = new SerializationFactory(config);
            this.keySerializer = serializationFactory.getSerializer(this.keyClass);
            if (this.keySerializer == null) {
                throw new IOException("Could not find a serializer for the Key class: '" + this.keyClass.getCanonicalName() + "'. Please ensure that the configuration '" + "io.serializations" + "' is properly configured, if you're usingcustom serialization.");
            }
            this.keySerializer.open(this.buffer);
            this.uncompressedValSerializer = serializationFactory.getSerializer(this.valClass);
            if (this.uncompressedValSerializer == null) {
                throw new IOException("Could not find a serializer for the Value class: '" + this.valClass.getCanonicalName() + "'. Please ensure that the configuration '" + "io.serializations" + "' is properly configured, if you're usingcustom serialization.");
            }
            this.uncompressedValSerializer.open(this.buffer);
            if (this.codec != null) {
                ReflectionUtils.setConf(this.codec, this.conf);
                this.compressor = CodecPool.getCompressor(this.codec);
                this.deflateFilter = this.codec.createOutputStream(this.buffer, this.compressor);
                this.deflateOut = new DataOutputStream(new BufferedOutputStream(this.deflateFilter));
                this.compressedValSerializer = serializationFactory.getSerializer(this.valClass);
                if (this.compressedValSerializer == null) {
                    throw new IOException("Could not find a serializer for the Value class: '" + this.valClass.getCanonicalName() + "'. Please ensure that the configuration '" + "io.serializations" + "' is properly configured, if you're usingcustom serialization.");
                }
                this.compressedValSerializer.open(this.deflateOut);
            }
            if (this.appendMode) {
                this.sync();
            } else {
                this.writeFileHeader();
            }
        }

        public Class getKeyClass() {
            return this.keyClass;
        }

        public Class getValueClass() {
            return this.valClass;
        }

        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }

        public void sync() throws IOException {
            if (this.sync != null && this.lastSyncPos != this.out.getPos()) {
                this.out.writeInt(-1);
                this.out.write(this.sync);
                this.lastSyncPos = this.out.getPos();
            }
        }

        @Deprecated
        public void syncFs() throws IOException {
            if (this.out != null) {
                this.out.hflush();
            }
        }

        @Override
        public void hsync() throws IOException {
            if (this.out != null) {
                this.out.hsync();
            }
        }

        @Override
        public void hflush() throws IOException {
            if (this.out != null) {
                this.out.hflush();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        @Override
        public boolean hasCapability(String capability) {
            if (this.out != null && capability != null) {
                return this.out.hasCapability(capability);
            }
            return false;
        }

        Configuration getConf() {
            return this.conf;
        }

        @Override
        public synchronized void close() throws IOException {
            this.keySerializer.close();
            this.uncompressedValSerializer.close();
            if (this.compressedValSerializer != null) {
                this.compressedValSerializer.close();
            }
            CodecPool.returnCompressor(this.compressor);
            this.compressor = null;
            if (this.out != null) {
                if (this.ownOutputStream) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
                this.out = null;
            }
        }

        synchronized void checkAndWriteSync() throws IOException {
            if (this.sync != null && this.out.getPos() >= this.lastSyncPos + (long)this.syncInterval) {
                this.sync();
            }
        }

        public void append(Writable key, Writable val) throws IOException {
            this.append((Object)key, (Object)val);
        }

        public synchronized void append(Object key, Object val) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass().getName() + " is not " + this.keyClass);
            }
            if (val.getClass() != this.valClass) {
                throw new IOException("wrong value class: " + val.getClass().getName() + " is not " + this.valClass);
            }
            this.buffer.reset();
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + key);
            }
            if (this.compress == CompressionType.RECORD) {
                this.deflateFilter.resetState();
                this.compressedValSerializer.serialize(val);
                this.deflateOut.flush();
                this.deflateFilter.finish();
            } else {
                this.uncompressedValSerializer.serialize(val);
            }
            this.checkAndWriteSync();
            this.out.writeInt(this.buffer.getLength());
            this.out.writeInt(keyLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
        }

        public synchronized void appendRaw(byte[] keyData, int keyOffset, int keyLength, ValueBytes val) throws IOException {
            if (keyLength < 0) {
                throw new IOException("negative length keys not allowed: " + keyLength);
            }
            int valLength = val.getSize();
            this.checkAndWriteSync();
            this.out.writeInt(keyLength + valLength);
            this.out.writeInt(keyLength);
            this.out.write(keyData, keyOffset, keyLength);
            val.writeUncompressedBytes(this.out);
        }

        public synchronized long getLength() throws IOException {
            return this.out.getPos();
        }

        private static class SyncIntervalOption
        extends Options.IntegerOption
        implements Option {
            SyncIntervalOption(int val) {
                super(val < 0 ? 102400 : val);
            }
        }

        private static class CompressionOption
        implements Option {
            private final CompressionType value;
            private final CompressionCodec codec;

            CompressionOption(CompressionType value) {
                this(value, null);
            }

            CompressionOption(CompressionType value, CompressionCodec codec) {
                this.value = value;
                this.codec = CompressionType.NONE != value && null == codec ? new DefaultCodec() : codec;
            }

            CompressionType getValue() {
                return this.value;
            }

            CompressionCodec getCodec() {
                return this.codec;
            }
        }

        static class ProgressableOption
        extends Options.ProgressableOption
        implements Option {
            ProgressableOption(Progressable value) {
                super(value);
            }
        }

        static class MetadataOption
        implements Option {
            private final Metadata value;

            MetadataOption(Metadata value) {
                this.value = value;
            }

            Metadata getValue() {
                return this.value;
            }
        }

        static class ValueClassOption
        extends Options.ClassOption
        implements Option {
            ValueClassOption(Class<?> value) {
                super(value);
            }
        }

        static class KeyClassOption
        extends Options.ClassOption
        implements Option {
            KeyClassOption(Class<?> value) {
                super(value);
            }
        }

        static class AppendIfExistsOption
        extends Options.BooleanOption
        implements Option {
            AppendIfExistsOption(boolean value) {
                super(value);
            }
        }

        static class ReplicationOption
        extends Options.IntegerOption
        implements Option {
            ReplicationOption(int value) {
                super(value);
            }
        }

        static class BlockSizeOption
        extends Options.LongOption
        implements Option {
            BlockSizeOption(long value) {
                super(value);
            }
        }

        static class BufferSizeOption
        extends Options.IntegerOption
        implements Option {
            BufferSizeOption(int value) {
                super(value);
            }
        }

        static class StreamOption
        extends Options.FSDataOutputStreamOption
        implements Option {
            StreamOption(FSDataOutputStream stream) {
                super(stream);
            }
        }

        @Deprecated
        private static class FileSystemOption
        implements Option {
            private final FileSystem value;

            protected FileSystemOption(FileSystem value) {
                this.value = value;
            }

            public FileSystem getValue() {
                return this.value;
            }
        }

        static class FileOption
        extends Options.PathOption
        implements Option {
            FileOption(Path path) {
                super(path);
            }
        }

        public static interface Option {
        }
    }

    public static class Metadata
    implements Writable {
        private TreeMap<Text, Text> theMetadata;

        public Metadata() {
            this(new TreeMap<Text, Text>());
        }

        public Metadata(TreeMap<Text, Text> arg) {
            this.theMetadata = arg == null ? new TreeMap() : arg;
        }

        public Text get(Text name) {
            return this.theMetadata.get(name);
        }

        public void set(Text name, Text value) {
            this.theMetadata.put(name, value);
        }

        public TreeMap<Text, Text> getMetadata() {
            return new TreeMap<Text, Text>((SortedMap<Text, Text>)this.theMetadata);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.theMetadata.size());
            for (Map.Entry<Text, Text> en : this.theMetadata.entrySet()) {
                en.getKey().write(out);
                en.getValue().write(out);
            }
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            int sz = in.readInt();
            if (sz < 0) {
                throw new IOException("Invalid size: " + sz + " for file metadata object");
            }
            this.theMetadata = new TreeMap();
            for (int i = 0; i < sz; ++i) {
                Text key = new Text();
                Text val = new Text();
                key.readFields(in);
                val.readFields(in);
                this.theMetadata.put(key, val);
            }
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return this.equals((Metadata)other);
        }

        public boolean equals(Metadata other) {
            if (other == null) {
                return false;
            }
            if (this.theMetadata.size() != other.theMetadata.size()) {
                return false;
            }
            Iterator<Map.Entry<Text, Text>> iter1 = this.theMetadata.entrySet().iterator();
            Iterator<Map.Entry<Text, Text>> iter2 = other.theMetadata.entrySet().iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Map.Entry<Text, Text> en1 = iter1.next();
                Map.Entry<Text, Text> en2 = iter2.next();
                if (!en1.getKey().equals(en2.getKey())) {
                    return false;
                }
                if (en1.getValue().equals(en2.getValue())) continue;
                return false;
            }
            return !iter1.hasNext() && !iter2.hasNext();
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("size: ").append(this.theMetadata.size()).append("\n");
            for (Map.Entry<Text, Text> en : this.theMetadata.entrySet()) {
                sb.append("\t").append(en.getKey().toString()).append("\t").append(en.getValue().toString()).append("\n");
            }
            return sb.toString();
        }
    }

    private static class CompressedBytes
    implements ValueBytes {
        private int dataSize = 0;
        private byte[] data = null;
        DataInputBuffer rawData = null;
        CompressionCodec codec = null;
        CompressionInputStream decompressedStream = null;

        private CompressedBytes(CompressionCodec codec) {
            this.codec = codec;
        }

        private void reset(DataInputStream in, int length) throws IOException {
            if (this.data == null) {
                this.data = new byte[length];
            } else if (length > this.data.length) {
                this.data = new byte[Math.max(length, this.data.length * 2)];
            }
            this.dataSize = -1;
            in.readFully(this.data, 0, length);
            this.dataSize = length;
        }

        @Override
        public int getSize() {
            return this.dataSize;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            if (this.decompressedStream == null) {
                this.rawData = new DataInputBuffer();
                this.decompressedStream = this.codec.createInputStream(this.rawData);
            } else {
                this.decompressedStream.resetState();
            }
            this.rawData.reset(this.data, 0, this.dataSize);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = this.decompressedStream.read(buffer, 0, 8192)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            outStream.write(this.data, 0, this.dataSize);
        }
    }

    private static class UncompressedBytes
    implements ValueBytes {
        private int dataSize = 0;
        private byte[] data = null;

        private UncompressedBytes() {
        }

        private void reset(DataInputStream in, int length) throws IOException {
            if (this.data == null) {
                this.data = new byte[length];
            } else if (length > this.data.length) {
                this.data = new byte[Math.max(length, this.data.length * 2)];
            }
            this.dataSize = -1;
            in.readFully(this.data, 0, length);
            this.dataSize = length;
        }

        @Override
        public int getSize() {
            return this.dataSize;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.data, 0, this.dataSize);
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new IllegalArgumentException("UncompressedBytes cannot be compressed!");
        }
    }

    public static interface ValueBytes {
        public void writeUncompressedBytes(DataOutputStream var1) throws IOException;

        public void writeCompressedBytes(DataOutputStream var1) throws IllegalArgumentException, IOException;

        public int getSize();
    }

    public static enum CompressionType {
        NONE,
        RECORD,
        BLOCK;

    }
}

