/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.lz4;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.compress.Compressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lz4Compressor
implements Compressor {
    private static final Logger LOG = LoggerFactory.getLogger((String)Lz4Compressor.class.getName());
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int uncompressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finish;
    private boolean finished;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private final LZ4Compressor lz4Compressor;

    public Lz4Compressor(int directBufferSize, boolean useLz4HC) {
        this.directBufferSize = directBufferSize;
        try {
            LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
            this.lz4Compressor = useLz4HC ? lz4Factory.highCompressor() : lz4Factory.fastCompressor();
        }
        catch (AssertionError t) {
            throw new RuntimeException("lz4-java library is not available: Lz4Compressor has not been loaded. You need to add lz4-java.jar to your CLASSPATH. " + t, (Throwable)((Object)t));
        }
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
    }

    public Lz4Compressor(int directBufferSize) {
        this(directBufferSize, false);
    }

    public Lz4Compressor() {
        this(65536);
    }

    @Override
    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.finished = false;
        if (len > this.uncompressedDirectBuf.remaining()) {
            this.userBuf = b;
            this.userBufOff = off;
            this.userBufLen = len;
        } else {
            ((ByteBuffer)this.uncompressedDirectBuf).put(b, off, len);
            this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
        }
        this.bytesRead += (long)len;
    }

    synchronized void setInputFromSavedData() {
        if (0 >= this.userBufLen) {
            return;
        }
        this.finished = false;
        this.uncompressedDirectBufLen = Math.min(this.userBufLen, this.directBufferSize);
        ((ByteBuffer)this.uncompressedDirectBuf).put(this.userBuf, this.userBufOff, this.uncompressedDirectBufLen);
        this.userBufOff += this.uncompressedDirectBufLen;
        this.userBufLen -= this.uncompressedDirectBufLen;
    }

    @Override
    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    @Override
    public synchronized boolean needsInput() {
        return this.compressedDirectBuf.remaining() <= 0 && this.uncompressedDirectBuf.remaining() != 0 && this.userBufLen <= 0;
    }

    @Override
    public synchronized void finish() {
        this.finish = true;
    }

    @Override
    public synchronized boolean finished() {
        return this.finish && this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    @Override
    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
            this.bytesWritten += (long)n;
            return n;
        }
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        if (0 == this.uncompressedDirectBuf.position()) {
            this.setInputFromSavedData();
            if (0 == this.uncompressedDirectBuf.position()) {
                this.finished = true;
                return 0;
            }
        }
        n = this.compressDirectBuf();
        this.compressedDirectBuf.limit(n);
        this.uncompressedDirectBuf.clear();
        if (0 == this.userBufLen) {
            this.finished = true;
        }
        n = Math.min(n, len);
        this.bytesWritten += (long)n;
        ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
        return n;
    }

    @Override
    public synchronized void reset() {
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.clear();
        this.uncompressedDirectBufLen = 0;
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.bytesWritten = 0L;
        this.bytesRead = 0L;
    }

    @Override
    public synchronized void reinit(Configuration conf) {
        this.reset();
    }

    @Override
    public synchronized long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public synchronized long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public synchronized void end() {
    }

    private int compressDirectBuf() {
        if (this.uncompressedDirectBufLen == 0) {
            return 0;
        }
        this.uncompressedDirectBuf.limit(this.uncompressedDirectBufLen).position(0);
        this.compressedDirectBuf.clear();
        this.lz4Compressor.compress((ByteBuffer)this.uncompressedDirectBuf, (ByteBuffer)this.compressedDirectBuf);
        this.uncompressedDirectBufLen = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize).position(0);
        int size = this.compressedDirectBuf.position();
        this.compressedDirectBuf.position(0);
        return size;
    }
}

