/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.sink;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricType;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsSink;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsTag;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class StatsDSink
implements MetricsSink,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(StatsDSink.class);
    private static final String PERIOD = ".";
    private static final String SERVER_HOST_KEY = "server.host";
    private static final String SERVER_PORT_KEY = "server.port";
    private static final String HOST_NAME_KEY = "host.name";
    private static final String SERVICE_NAME_KEY = "service.name";
    private static final String SKIP_HOSTNAME_KEY = "skip.hostname";
    private boolean skipHostname = false;
    private String hostName = null;
    private String serviceName = null;
    private StatsD statsd = null;

    @Override
    public void init(SubsetConfiguration conf) {
        String serverHost = conf.getString(SERVER_HOST_KEY);
        int serverPort = Integer.parseInt(conf.getString(SERVER_PORT_KEY));
        this.skipHostname = conf.getBoolean(SKIP_HOSTNAME_KEY, false);
        if (!this.skipHostname) {
            this.hostName = conf.getString(HOST_NAME_KEY, null);
            if (null == this.hostName) {
                this.hostName = NetUtils.getHostname();
            }
        }
        this.serviceName = conf.getString(SERVICE_NAME_KEY, null);
        this.statsd = new StatsD(serverHost, serverPort);
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        String hn = this.hostName;
        String ctx = record.context();
        String sn = this.serviceName;
        for (MetricsTag tag : record.tags()) {
            if (tag.info().name().equals(MsInfo.Hostname.name()) && tag.value() != null) {
                hn = tag.value();
                continue;
            }
            if (tag.info().name().equals(MsInfo.Context.name()) && tag.value() != null) {
                ctx = tag.value();
                continue;
            }
            if (!tag.info().name().equals(MsInfo.ProcessName.name()) || tag.value() == null) continue;
            sn = tag.value();
        }
        StringBuilder buf = new StringBuilder();
        if (!this.skipHostname && hn != null) {
            int idx = hn.indexOf(PERIOD);
            if (idx == -1) {
                buf.append(hn).append(PERIOD);
            } else {
                buf.append(hn.substring(0, idx)).append(PERIOD);
            }
        }
        buf.append(sn).append(PERIOD).append(ctx).append(PERIOD).append(record.name().replaceAll("\\.", "-")).append(PERIOD);
        for (AbstractMetric metric : record.metrics()) {
            String type = null;
            if (metric.type().equals((Object)MetricType.COUNTER)) {
                type = "c";
            } else if (metric.type().equals((Object)MetricType.GAUGE)) {
                type = "g";
            }
            StringBuilder line = new StringBuilder();
            line.append(buf.toString()).append(metric.name().replace(' ', '_')).append(":").append(metric.value()).append("|").append(type);
            this.writeMetric(line.toString());
        }
    }

    public void writeMetric(String line) {
        try {
            this.statsd.write(line);
        }
        catch (IOException e) {
            LOG.warn("Error sending metrics to StatsD", (Throwable)e);
            throw new MetricsException("Error writing metric to StatsD", e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.statsd.close();
    }

    public static class StatsD {
        private DatagramSocket socket = null;
        private DatagramPacket packet = null;
        private String serverHost;
        private int serverPort;

        public StatsD(String serverHost, int serverPort) {
            this.serverHost = serverHost;
            this.serverPort = serverPort;
        }

        public void createSocket() throws IOException {
            try {
                InetSocketAddress address = new InetSocketAddress(this.serverHost, this.serverPort);
                this.socket = new DatagramSocket();
                this.packet = new DatagramPacket("".getBytes(StandardCharsets.UTF_8), 0, 0, address.getAddress(), this.serverPort);
            }
            catch (IOException ioe) {
                throw NetUtils.wrapException(this.serverHost, this.serverPort, "localhost", 0, ioe);
            }
        }

        public void write(String msg) throws IOException {
            if (null == this.socket) {
                this.createSocket();
            }
            LOG.debug("Sending metric: {}", (Object)msg);
            this.packet.setData(msg.getBytes(StandardCharsets.UTF_8));
            this.socket.send(this.packet);
        }

        public void close() throws IOException {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            finally {
                this.socket = null;
            }
        }
    }
}

