/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.util.Quantile;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.util.QuantileEstimator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public class SampleQuantiles
implements QuantileEstimator {
    private long count = 0L;
    private LinkedList<SampleItem> samples;
    private long[] buffer = new long[500];
    private int bufferCount = 0;
    private final Quantile[] quantiles;

    public SampleQuantiles(Quantile[] quantiles) {
        this.quantiles = quantiles;
        this.samples = new LinkedList();
    }

    private double allowableError(int rank) {
        int size = this.samples.size();
        double minError = size + 1;
        for (Quantile q : this.quantiles) {
            double error = (double)rank <= q.quantile * (double)size ? 2.0 * q.error * (double)(size - rank) / (1.0 - q.quantile) : 2.0 * q.error * (double)rank / q.quantile;
            if (!(error < minError)) continue;
            minError = error;
        }
        return minError;
    }

    @Override
    public synchronized void insert(long v) {
        this.buffer[this.bufferCount] = v;
        ++this.bufferCount;
        ++this.count;
        if (this.bufferCount == this.buffer.length) {
            this.insertBatch();
            this.compress();
        }
    }

    private void insertBatch() {
        if (this.bufferCount == 0) {
            return;
        }
        Arrays.sort(this.buffer, 0, this.bufferCount);
        int start = 0;
        if (this.samples.size() == 0) {
            SampleItem newItem = new SampleItem(this.buffer[0], 1, 0);
            this.samples.add(newItem);
            ++start;
        }
        ListIterator<SampleItem> it = this.samples.listIterator();
        SampleItem item = (SampleItem)it.next();
        for (int i = start; i < this.bufferCount; ++i) {
            long v = this.buffer[i];
            while (it.nextIndex() < this.samples.size() && item.value < v) {
                item = (SampleItem)it.next();
            }
            if (item.value > v) {
                it.previous();
            }
            int delta = it.previousIndex() == 0 || it.nextIndex() == this.samples.size() ? 0 : (int)Math.floor(this.allowableError(it.nextIndex())) - 1;
            SampleItem newItem = new SampleItem(v, 1, delta);
            it.add(newItem);
            item = newItem;
        }
        this.bufferCount = 0;
    }

    private void compress() {
        if (this.samples.size() < 2) {
            return;
        }
        ListIterator it = this.samples.listIterator();
        SampleItem prev = null;
        SampleItem next = (SampleItem)it.next();
        while (it.hasNext()) {
            prev = next;
            next = (SampleItem)it.next();
            if (!((double)(prev.g + next.g + next.delta) <= this.allowableError(it.previousIndex()))) continue;
            next.g += prev.g;
            it.previous();
            it.previous();
            it.remove();
            it.next();
        }
    }

    private long query(double quantile) {
        Preconditions.checkState(!this.samples.isEmpty(), "no data in estimator");
        int rankMin = 0;
        int desired = (int)(quantile * (double)this.count);
        ListIterator it = this.samples.listIterator();
        SampleItem prev = null;
        SampleItem cur = (SampleItem)it.next();
        for (int i = 1; i < this.samples.size(); ++i) {
            prev = cur;
            cur = (SampleItem)it.next();
            if (!((double)((rankMin += prev.g) + cur.g + cur.delta) > (double)desired + this.allowableError(i) / 2.0)) continue;
            return prev.value;
        }
        return this.samples.get((int)(this.samples.size() - 1)).value;
    }

    @Override
    public synchronized Map<Quantile, Long> snapshot() {
        this.insertBatch();
        if (this.samples.isEmpty()) {
            return null;
        }
        TreeMap<Quantile, Long> values = new TreeMap<Quantile, Long>();
        for (int i = 0; i < this.quantiles.length; ++i) {
            values.put(this.quantiles[i], this.query(this.quantiles[i].quantile));
        }
        return values;
    }

    @Override
    public synchronized long getCount() {
        return this.count;
    }

    @VisibleForTesting
    public synchronized int getSampleCount() {
        return this.samples.size();
    }

    @Override
    public synchronized void clear() {
        this.count = 0L;
        this.bufferCount = 0;
        this.samples.clear();
    }

    public synchronized String toString() {
        Map<Quantile, Long> data = this.snapshot();
        if (data == null) {
            return "[no samples]";
        }
        return Joiner.on("\n").withKeyValueSeparator(": ").join(data);
    }

    private static class SampleItem {
        public final long value;
        public int g;
        public final int delta;

        public SampleItem(long value, int lowerDelta, int delta) {
            this.value = value;
            this.g = lowerDelta;
            this.delta = delta;
        }

        public String toString() {
            return String.format("%d, %d, %d", this.value, this.g, this.delta);
        }
    }
}

