/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.util.SignerSecretProvider;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class FileSignerSecretProvider
extends SignerSecretProvider {
    private byte[] secret;
    private byte[][] secrets;

    @Override
    public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
        String signatureSecretFile = config.getProperty("signature.secret.file", null);
        if (signatureSecretFile != null) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(Paths.get(signatureSecretFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                StringBuilder sb = new StringBuilder();
                int c = ((Reader)reader).read();
                while (c > -1) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
                this.secret = sb.toString().getBytes(StandardCharsets.UTF_8);
                if (this.secret.length == 0) {
                    throw new RuntimeException("No secret in signature secret file: " + signatureSecretFile);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read signature secret file: " + signatureSecretFile);
            }
        }
        this.secrets = new byte[][]{this.secret};
    }

    @Override
    public byte[] getCurrentSecret() {
        return this.secret;
    }

    @Override
    public byte[][] getAllSecrets() {
        return this.secrets;
    }
}

