/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ServletUtil {
    public static final String HTML_TAIL = "<hr />\n<a href='http://hadoop.apache.org'>Hadoop</a>, " + Calendar.getInstance().get(1) + ".\n</body></html>";

    public static PrintWriter initHTML(ServletResponse response, String title) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>\n<link rel='stylesheet' type='text/css' href='/static/hadoop.css'>\n<title>" + title + "</title>\n<body>\n<h1>" + title + "</h1>\n");
        return out;
    }

    public static String getParameter(ServletRequest request, String name) {
        String s2 = request.getParameter(name);
        if (s2 == null) {
            return null;
        }
        return (s2 = s2.trim()).length() == 0 ? null : s2;
    }

    public static long parseLongParam(ServletRequest request, String param) throws IOException {
        String paramStr = request.getParameter(param);
        if (paramStr == null) {
            throw new IOException("Invalid request has no " + param + " parameter");
        }
        return Long.parseLong(paramStr);
    }

    public static String htmlFooter() {
        return HTML_TAIL;
    }

    public static String getRawPath(HttpServletRequest request, String servletName) {
        Preconditions.checkArgument(request.getRequestURI().startsWith(servletName + "/"));
        return request.getRequestURI().substring(servletName.length());
    }
}

