/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class CompositeArgumentTypeStrategy
implements ArgumentTypeStrategy {
    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType dataType = callContext.getArgumentDataTypes().get(argumentPos);
        if (!LogicalTypeChecks.isCompositeType(dataType.getLogicalType())) {
            if (throwOnFailure) {
                throw callContext.newValidationError("A composite type expected. Got: %s", dataType);
            }
            return Optional.empty();
        }
        return Optional.of(dataType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("<COMPOSITE>");
    }
}

