/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FieldReferenceExpression
implements ResolvedExpression {
    private final String name;
    private final DataType dataType;
    private final int inputIndex;
    private final int fieldIndex;

    public FieldReferenceExpression(String name, DataType dataType, int inputIndex, int fieldIndex) {
        Preconditions.checkArgument((inputIndex >= 0 ? 1 : 0) != 0, (Object)"Index of input should be a positive number");
        Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"Index of field should be a positive number");
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Field name must not be null.");
        this.dataType = (DataType)Preconditions.checkNotNull((Object)dataType, (String)"Field data type must not be null.");
        this.inputIndex = inputIndex;
        this.fieldIndex = fieldIndex;
    }

    public String getName() {
        return this.name;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSummaryString() {
        return this.name;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldReferenceExpression that = (FieldReferenceExpression)o;
        return this.name.equals(that.name) && this.dataType.equals(that.dataType) && this.inputIndex == that.inputIndex && this.fieldIndex == that.fieldIndex;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.inputIndex, this.fieldIndex);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

