/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar.vector.heap;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableIntVector;

@Internal
public class HeapIntVector
extends AbstractHeapVector
implements WritableIntVector {
    private static final long serialVersionUID = -2749499358889718254L;
    public int[] vector;

    public HeapIntVector(int len) {
        super(len);
        this.vector = new int[len];
    }

    @Override
    public int getInt(int i) {
        if (this.dictionary == null) {
            return this.vector[i];
        }
        return this.dictionary.decodeToInt(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setInt(int i, int value) {
        this.vector[i] = value;
    }

    @Override
    public void setIntsFromBinary(int rowId, int count, byte[] src, int srcIndex) {
        if (rowId + count > this.vector.length || (long)srcIndex + (long)count * 4L > (long)src.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds, row id is %s, count is %s, binary src index is %s, binary length is %s, int array src index is %s, int array length is %s.", rowId, count, srcIndex, src.length, rowId, this.vector.length));
        }
        if (LITTLE_ENDIAN) {
            UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + srcIndex, this.vector, (long)INT_ARRAY_OFFSET + (long)rowId * 4L, (long)count * 4L);
        } else {
            long srcOffset = srcIndex + BYTE_ARRAY_OFFSET;
            int i = 0;
            while (i < count) {
                this.vector[i + rowId] = Integer.reverseBytes(UNSAFE.getInt(src, srcOffset));
                ++i;
                srcOffset += 4L;
            }
        }
    }

    @Override
    public void setInts(int rowId, int count, int value) {
        for (int i = 0; i < count; ++i) {
            this.vector[i + rowId] = value;
        }
    }

    @Override
    public void setInts(int rowId, int count, int[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.vector, rowId, count);
    }

    @Override
    public void fill(int value) {
        Arrays.fill(this.vector, value);
    }
}

