/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.rest.ExistsResource;
import org.apache.hadoop.hbase.rest.MultiRowResource;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RegionsResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowResource;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.SchemaResource;
import org.apache.hadoop.hbase.rest.TableScanResource;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableResource
extends ResourceBase {
    String table;
    private static final Logger LOG = LoggerFactory.getLogger(TableResource.class);

    public TableResource(String table) throws IOException {
        this.table = table;
    }

    String getName() {
        return this.table;
    }

    boolean exists() throws IOException {
        return this.servlet.getAdmin().tableExists(TableName.valueOf((String)this.table));
    }

    @Path(value="exists")
    public ExistsResource getExistsResource() throws IOException {
        return new ExistsResource(this);
    }

    @Path(value="regions")
    public RegionsResource getRegionsResource() throws IOException {
        return new RegionsResource(this);
    }

    @Path(value="scanner")
    public ScannerResource getScannerResource() throws IOException {
        return new ScannerResource(this);
    }

    @Path(value="schema")
    public SchemaResource getSchemaResource() throws IOException {
        return new SchemaResource(this);
    }

    @Path(value="{multiget: multiget.*}")
    public MultiRowResource getMultipleRowResource(@QueryParam(value="v") String versions, @PathParam(value="multiget") String path) throws IOException {
        return new MultiRowResource(this, versions, path.replace("multiget", "").replace("/", ""));
    }

    @Path(value="{rowspec: [^*]+}")
    public RowResource getRowResource(@PathParam(value="rowspec") @Encoded String rowspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check, @QueryParam(value="rr") String returnResult) throws IOException {
        return new RowResource(this, rowspec, versions, check, returnResult);
    }

    @Path(value="{suffixglobbingspec: .*\\*/.+}")
    public RowResource getRowResourceWithSuffixGlobbing(@PathParam(value="suffixglobbingspec") @Encoded String suffixglobbingspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check, @QueryParam(value="rr") String returnResult) throws IOException {
        return new RowResource(this, suffixglobbingspec, versions, check, returnResult);
    }

    @Path(value="{scanspec: .*[*]$}")
    public TableScanResource getScanResource(@PathParam(value="scanspec") String scanSpec, @DefaultValue(value="2147483647") @QueryParam(value="limit") int userRequestedLimit, @DefaultValue(value="") @QueryParam(value="startrow") String startRow, @DefaultValue(value="") @QueryParam(value="endrow") String endRow, @DefaultValue(value="") @QueryParam(value="column") List<String> column, @DefaultValue(value="1") @QueryParam(value="maxversions") int maxVersions, @DefaultValue(value="-1") @QueryParam(value="batchsize") int batchSize, @DefaultValue(value="0") @QueryParam(value="starttime") long startTime, @DefaultValue(value="9223372036854775807") @QueryParam(value="endtime") long endTime, @DefaultValue(value="true") @QueryParam(value="cacheblocks") boolean cacheBlocks, @DefaultValue(value="false") @QueryParam(value="reversed") boolean reversed, @DefaultValue(value="") @QueryParam(value="filter") String paramFilter) {
        try {
            Object prefixBytes;
            PrefixFilter prefixFilter = null;
            Scan tableScan = new Scan();
            if (scanSpec.indexOf(42) > 0) {
                String prefix = scanSpec.substring(0, scanSpec.indexOf(42));
                prefixBytes = Bytes.toBytes((String)prefix);
                prefixFilter = new PrefixFilter(Bytes.toBytes((String)prefix));
                if (startRow.isEmpty()) {
                    tableScan.setStartRow((byte[])prefixBytes);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Query parameters  : Table Name = > " + this.table + " Start Row => " + startRow + " End Row => " + endRow + " Columns => " + column + " Start Time => " + startTime + " End Time => " + endTime + " Cache Blocks => " + cacheBlocks + " Max Versions => " + maxVersions + " Batch Size => " + batchSize);
            }
            Table hTable = RESTServlet.getInstance().getTable(this.table);
            tableScan.setBatch(batchSize);
            tableScan.setMaxVersions(maxVersions);
            tableScan.setTimeRange(startTime, endTime);
            if (!startRow.isEmpty()) {
                tableScan.setStartRow(Bytes.toBytes((String)startRow));
            }
            tableScan.setStopRow(Bytes.toBytes((String)endRow));
            prefixBytes = column.iterator();
            while (prefixBytes.hasNext()) {
                String csplit = (String)prefixBytes.next();
                String[] familysplit = csplit.trim().split(":");
                if (familysplit.length == 2) {
                    if (familysplit[1].length() > 0) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Scan family and column : " + familysplit[0] + "  " + familysplit[1]);
                        }
                        tableScan.addColumn(Bytes.toBytes((String)familysplit[0]), Bytes.toBytes((String)familysplit[1]));
                        continue;
                    }
                    tableScan.addFamily(Bytes.toBytes((String)familysplit[0]));
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Scan family : " + familysplit[0] + " and empty qualifier.");
                    }
                    tableScan.addColumn(Bytes.toBytes((String)familysplit[0]), null);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)familysplit[0])) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Scan family : " + familysplit[0]);
                }
                tableScan.addFamily(Bytes.toBytes((String)familysplit[0]));
            }
            FilterList filterList = new FilterList(new Filter[0]);
            if (StringUtils.isNotEmpty((CharSequence)paramFilter)) {
                ParseFilter pf = new ParseFilter();
                Filter parsedParamFilter = pf.parseFilterString(paramFilter);
                if (parsedParamFilter != null) {
                    filterList.addFilter(parsedParamFilter);
                }
                if (prefixFilter != null) {
                    filterList.addFilter((Filter)prefixFilter);
                }
            }
            if (filterList.size() > 0) {
                tableScan.setFilter((Filter)filterList);
            }
            int fetchSize = this.servlet.getConfiguration().getInt("hbase.rest.scan.fetchsize", 10);
            tableScan.setCaching(fetchSize);
            tableScan.setReversed(reversed);
            tableScan.setCacheBlocks(cacheBlocks);
            return new TableScanResource(hTable.getScanner(tableScan), userRequestedLimit);
        }
        catch (IOException exp) {
            this.servlet.getMetrics().incrementFailedScanRequests(1);
            this.processException(exp);
            LOG.warn(exp.toString(), (Throwable)exp);
            return null;
        }
    }
}

