/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.Config;
import org.apache.heron.api.HeronTopology;
import org.apache.heron.api.exception.AlreadyAliveException;
import org.apache.heron.api.exception.InvalidTopologyException;
import org.apache.heron.api.exception.TopologySubmissionException;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.utils.TopologyUtils;
import org.apache.heron.api.utils.Utils;

public final class HeronSubmitter {
    private static final Logger LOG = Logger.getLogger(HeronSubmitter.class.getName());
    private static final String TOPOLOGY_DEFINITION_SUFFIX = ".defn";
    private static final String CMD_TOPOLOGY_INITIAL_STATE = "cmdline.topology.initial.state";
    private static final String CMD_TOPOLOGY_DEFN_TEMPDIR = "cmdline.topologydefn.tmpdirectory";
    private static final String CMD_TOPOLOGY_ROLE = "cmdline.topology.role";
    private static final String CMD_TOPOLOGY_ENVIRONMENT = "cmdline.topology.environment";

    private HeronSubmitter() {
    }

    public static void submitTopology(String name, Config heronConfig, HeronTopology topology) throws AlreadyAliveException, InvalidTopologyException {
        String environment;
        Map<String, String> heronCmdOptions = HeronSubmitter.getHeronCmdOptions();
        TopologyAPI.TopologyState initialState = heronCmdOptions.get(CMD_TOPOLOGY_INITIAL_STATE) != null ? TopologyAPI.TopologyState.valueOf(heronCmdOptions.get(CMD_TOPOLOGY_INITIAL_STATE)) : TopologyAPI.TopologyState.RUNNING;
        LOG.log(Level.FINE, "To deploy a topology in initial state {0}", (Object)initialState);
        String role = heronCmdOptions.get(CMD_TOPOLOGY_ROLE);
        if (role != null) {
            heronConfig.putIfAbsent("topology.team.name", role);
        }
        if ((environment = heronCmdOptions.get(CMD_TOPOLOGY_ENVIRONMENT)) != null) {
            heronConfig.putIfAbsent("topology.team.environment", environment);
        }
        TopologyAPI.Topology fTopology = topology.setConfig(heronConfig).setName(name).setState(initialState).getTopology();
        TopologyUtils.validateTopology(fTopology);
        assert (fTopology.isInitialized());
        HeronSubmitter.submitTopologyToFile(fTopology, heronCmdOptions);
    }

    private static void submitTopologyToFile(TopologyAPI.Topology fTopology, Map<String, String> heronCmdOptions) {
        String dirName = heronCmdOptions.get(CMD_TOPOLOGY_DEFN_TEMPDIR);
        if (dirName == null || dirName.isEmpty()) {
            throw new TopologySubmissionException("Topology definition temp directory not specified. Please set cmdline option: cmdline.topologydefn.tmpdirectory");
        }
        String fileName = Paths.get(dirName, fTopology.getName() + TOPOLOGY_DEFINITION_SUFFIX).toString();
        try (FileOutputStream fos = new FileOutputStream(new File(fileName));
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            byte[] topEncoding = fTopology.toByteArray();
            bos.write(topEncoding);
        }
        catch (IOException e) {
            throw new TopologySubmissionException("Error writing topology definition to temp directory: " + dirName, e);
        }
    }

    public static String submitJar(Config config, String localJar) {
        throw new UnsupportedOperationException("submitJar functionality is unsupported");
    }

    static Map<String, String> getHeronCmdOptions() {
        return Utils.readCommandLineOpts();
    }
}

