/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.classification;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.heron.classification.InterfaceStability.Unstable", "org.apache.heron.classification.InterfaceAudience.Private", "org.apache.heron.classification.InterfaceAudience.LimitedPrivate"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class HeronAnnotationProcessor
extends AbstractProcessor {
    private ProcessingEnvironment env;

    @Override
    public synchronized void init(ProcessingEnvironment pe) {
        this.env = pe;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    if (element.toString().startsWith("org.apache.heron")) continue;
                    this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("%s extends from a class annotated with %s", element, typeElement), element);
                }
            }
        }
        return true;
    }
}

