/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.heron.api.metric.IMetric;
import org.apache.heron.api.state.State;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.streamlet.Context;

public class ContextImpl
implements Context {
    private TopologyContext topologyContext;
    private Map<String, Object> topologyConfig;
    private State<Serializable, Serializable> state;

    public ContextImpl(TopologyContext topologyContext, Map<String, Object> topologyConfig, State<Serializable, Serializable> state) {
        this.topologyContext = topologyContext;
        this.topologyConfig = topologyConfig;
        this.state = state;
    }

    @Override
    public int getTaskId() {
        return this.topologyContext.getThisTaskId();
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.topologyConfig;
    }

    @Override
    public String getStreamName() {
        return this.topologyContext.getThisStreams().iterator().next();
    }

    @Override
    public int getStreamPartition() {
        return this.topologyContext.getThisTaskIndex();
    }

    @Override
    public <T> void registerMetric(String metricName, int collectionInterval, Supplier<T> metricFn) {
        this.topologyContext.registerMetric(metricName, new StreamletMetric<T>(metricFn), collectionInterval);
    }

    @Override
    public State<Serializable, Serializable> getState() {
        return this.state;
    }

    private class StreamletMetric<T>
    implements IMetric<T> {
        private Supplier<T> metricFn;

        StreamletMetric(Supplier<T> metricFn) {
            this.metricFn = metricFn;
        }

        @Override
        public T getValueAndReset() {
            return this.metricFn.get();
        }
    }
}

