/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public enum OrcConf {
    STRIPE_SIZE("orc.stripe.size", "hive.exec.orc.default.stripe.size", 0x4000000L, "Define the default ORC stripe size, in bytes."),
    BLOCK_SIZE("orc.block.size", "hive.exec.orc.default.block.size", 0x10000000L, "Define the default file system block size for ORC files."),
    ENABLE_INDEXES("orc.create.index", "orc.create.index", true, "Should the ORC writer create indexes as part of the file."),
    ROW_INDEX_STRIDE("orc.row.index.stride", "hive.exec.orc.default.row.index.stride", 10000, "Define the default ORC index stride in number of rows. (Stride is the\n number of rows n index entry represents.)"),
    BUFFER_SIZE("orc.compress.size", "hive.exec.orc.default.buffer.size", 262144, "Define the default ORC buffer size, in bytes."),
    BLOCK_PADDING("orc.block.padding", "hive.exec.orc.default.block.padding", true, "Define whether stripes should be padded to the HDFS block boundaries."),
    COMPRESS("orc.compress", "hive.exec.orc.default.compress", "ZLIB", "Define the default compression codec for ORC file"),
    WRITE_FORMAT("orc.write.format", "hive.exec.orc.write.format", "0.12", "Define the version of the file to write. Possible values are 0.11 and\n 0.12. If this parameter is not defined, ORC will use the run\n length encoding (RLE) introduced in Hive 0.12."),
    ENCODING_STRATEGY("orc.encoding.strategy", "hive.exec.orc.encoding.strategy", "SPEED", "Define the encoding strategy to use while writing data. Changing this\nwill only affect the light weight encoding for integers. This\nflag will not change the compression level of higher level\ncompression codec (like ZLIB)."),
    COMPRESSION_STRATEGY("orc.compression.strategy", "hive.exec.orc.compression.strategy", "SPEED", "Define the compression strategy to use while writing data.\nThis changes the compression level of higher level compression\ncodec (like ZLIB)."),
    BLOCK_PADDING_TOLERANCE("orc.block.padding.tolerance", "hive.exec.orc.block.padding.tolerance", 0.05, "Define the tolerance for block padding as a decimal fraction of\nstripe size (for example, the default value 0.05 is 5% of the\nstripe size). For the defaults of 64Mb ORC stripe and 256Mb HDFS\nblocks, the default block padding tolerance of 5% will\nreserve a maximum of 3.2Mb for padding within the 256Mb block.\nIn that case, if the available size within the block is more than\n3.2Mb, a new smaller stripe will be inserted to fit within that\nspace. This will make sure that no stripe written will block\n boundaries and cause remote reads within a node local task."),
    BLOOM_FILTER_FPP("orc.bloom.filter.fpp", "orc.default.bloom.fpp", 0.05, "Define the default false positive probability for bloom filters."),
    USE_ZEROCOPY("orc.use.zerocopy", "hive.exec.orc.zerocopy", false, "Use zerocopy reads with ORC. (This requires Hadoop 2.3 or later.)"),
    SKIP_CORRUPT_DATA("orc.skip.corrupt.data", "hive.exec.orc.skip.corrupt.data", false, "If ORC reader encounters corrupt data, this value will be used to\ndetermine whether to skip the corrupt data or throw exception.\nThe default behavior is to throw exception."),
    MEMORY_POOL("orc.memory.pool", "hive.exec.orc.memory.pool", 0.5, "Maximum fraction of heap that can be used by ORC file writers"),
    DICTIONARY_KEY_SIZE_THRESHOLD("orc.dictionary.key.threshold", "hive.exec.orc.dictionary.key.size.threshold", 0.8, "If the number of distinct keys in a dictionary is greater than this\nfraction of the total number of non-null rows, turn off \ndictionary encoding.  Use 1 to always use dictionary encoding."),
    ROW_INDEX_STRIDE_DICTIONARY_CHECK("orc.dictionary.early.check", "hive.orc.row.index.stride.dictionary.check", true, "If enabled dictionary check will happen after first row index stride\n(default 10000 rows) else dictionary check will happen before\nwriting first stripe. In both cases, the decision to use\ndictionary or not will be retained thereafter."),
    BLOOM_FILTER_COLUMNS("orc.bloom.filter.columns", "orc.bloom.filter.columns", "", "List of columns to create bloom filters for when writing.");

    private final String attribute;
    private final String hiveConfName;
    private final Object defaultValue;
    private final String description;

    private OrcConf(String attribute, String hiveConfName, Object defaultValue, String description) {
        this.attribute = attribute;
        this.hiveConfName = hiveConfName;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getHiveConfName() {
        return this.hiveConfName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    private String lookupValue(Properties tbl, Configuration conf) {
        String result = null;
        if (tbl != null) {
            result = tbl.getProperty(this.attribute);
        }
        if (result == null && conf != null && (result = conf.get(this.attribute)) == null) {
            result = conf.get(this.hiveConfName);
        }
        return result;
    }

    public long getLong(Properties tbl, Configuration conf) {
        String value = this.lookupValue(tbl, conf);
        if (value != null) {
            return Long.parseLong(value);
        }
        return ((Number)this.defaultValue).longValue();
    }

    public long getLong(Configuration conf) {
        return this.getLong(null, conf);
    }

    public String getString(Properties tbl, Configuration conf) {
        String value = this.lookupValue(tbl, conf);
        return value == null ? (String)this.defaultValue : value;
    }

    public String getString(Configuration conf) {
        return this.getString(null, conf);
    }

    public boolean getBoolean(Properties tbl, Configuration conf) {
        String value = this.lookupValue(tbl, conf);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return (Boolean)this.defaultValue;
    }

    public boolean getBoolean(Configuration conf) {
        return this.getBoolean(null, conf);
    }

    public double getDouble(Properties tbl, Configuration conf) {
        String value = this.lookupValue(tbl, conf);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return ((Number)this.defaultValue).doubleValue();
    }

    public double getDouble(Configuration conf) {
        return this.getDouble(null, conf);
    }
}

