/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;

public class OrcUtils {
    public static boolean[] includeColumns(String selectedColumns, TypeDescription schema) {
        int numFlattenedCols = schema.getMaximumId();
        boolean[] results = new boolean[numFlattenedCols + 1];
        if ("*".equals(selectedColumns)) {
            Arrays.fill(results, true);
            return results;
        }
        if (selectedColumns != null && schema.getCategory() == TypeDescription.Category.STRUCT) {
            List<String> fieldNames = schema.getFieldNames();
            List<TypeDescription> fields = schema.getChildren();
            for (String column : selectedColumns.split(",")) {
                TypeDescription col = OrcUtils.findColumn(column, fieldNames, fields);
                if (col == null) continue;
                for (int i = col.getId(); i <= col.getMaximumId(); ++i) {
                    results[i] = true;
                }
            }
        }
        return results;
    }

    private static TypeDescription findColumn(String columnName, List<String> fieldNames, List<TypeDescription> fields) {
        int i = 0;
        for (String fieldName : fieldNames) {
            if (fieldName.equalsIgnoreCase(columnName)) {
                return fields.get(i);
            }
            ++i;
        }
        return null;
    }

    public static List<OrcProto.Type> getOrcTypes(TypeDescription typeDescr) {
        ArrayList result = Lists.newArrayList();
        OrcUtils.appendOrcTypes(result, typeDescr);
        return result;
    }

    private static void appendOrcTypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        List<TypeDescription> children = typeDescr.getChildren();
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(children.get(0).getId());
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                for (String field : typeDescr.getFieldNames()) {
                    type.addFieldNames(field);
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        result.add(type.build());
        if (children != null) {
            for (TypeDescription child : children) {
                OrcUtils.appendOrcTypes(result, child);
            }
        }
    }

    public static void appendOrcTypesRebuildSubtypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        int subtype = result.size();
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        boolean needsAdd = true;
        List<TypeDescription> children = typeDescr.getChildren();
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(++subtype);
                result.add(type.build());
                needsAdd = false;
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(0));
                break;
            }
            case MAP: {
                result.add(null);
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(0));
                int subtype2 = result.size();
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(1));
                type.setKind(OrcProto.Type.Kind.MAP);
                type.addSubtypes(subtype + 1);
                type.addSubtypes(subtype2);
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            case STRUCT: {
                List<String> fieldNames = typeDescr.getFieldNames();
                result.add(null);
                ArrayList<Integer> fieldSubtypes = new ArrayList<Integer>(fieldNames.size());
                for (TypeDescription child : children) {
                    int fieldSubtype = result.size();
                    fieldSubtypes.add(fieldSubtype);
                    OrcUtils.appendOrcTypesRebuildSubtypes(result, child);
                }
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (int i = 0; i < fieldNames.size(); ++i) {
                    type.addSubtypes((Integer)fieldSubtypes.get(i));
                    type.addFieldNames(fieldNames.get(i));
                }
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            case UNION: {
                result.add(null);
                ArrayList<Integer> unionSubtypes = new ArrayList<Integer>(children.size());
                for (TypeDescription child : children) {
                    int unionSubtype = result.size();
                    unionSubtypes.add(unionSubtype);
                    OrcUtils.appendOrcTypesRebuildSubtypes(result, child);
                }
                type.setKind(OrcProto.Type.Kind.UNION);
                for (int i = 0; i < children.size(); ++i) {
                    type.addSubtypes((Integer)unionSubtypes.get(i));
                }
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        if (needsAdd) {
            result.add(type.build());
        }
    }

    public static int appendOrcTypesRebuildSubtypes(List<OrcProto.Type> result, List<OrcProto.Type> types, int columnId) {
        OrcProto.Type oldType = types.get(columnId++);
        int subtype = result.size();
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder();
        boolean needsAdd = true;
        switch (oldType.getKind()) {
            case BOOLEAN: {
                builder.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                builder.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                builder.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                builder.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                builder.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                builder.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                builder.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                builder.setKind(OrcProto.Type.Kind.CHAR);
                builder.setMaximumLength(oldType.getMaximumLength());
                break;
            }
            case VARCHAR: {
                builder.setKind(OrcProto.Type.Kind.VARCHAR);
                builder.setMaximumLength(oldType.getMaximumLength());
                break;
            }
            case BINARY: {
                builder.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                builder.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                builder.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                builder.setKind(OrcProto.Type.Kind.DECIMAL);
                builder.setPrecision(oldType.getPrecision());
                builder.setScale(oldType.getScale());
                break;
            }
            case LIST: {
                builder.setKind(OrcProto.Type.Kind.LIST);
                builder.addSubtypes(++subtype);
                result.add(builder.build());
                needsAdd = false;
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                break;
            }
            case MAP: {
                result.add(null);
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                int subtype2 = result.size();
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                builder.setKind(OrcProto.Type.Kind.MAP);
                builder.addSubtypes(subtype + 1);
                builder.addSubtypes(subtype2);
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            case STRUCT: {
                int i;
                List<String> fieldNames = oldType.getFieldNamesList();
                result.add(null);
                ArrayList<Integer> fieldSubtypes = new ArrayList<Integer>(fieldNames.size());
                for (i = 0; i < fieldNames.size(); ++i) {
                    int fieldSubtype = result.size();
                    fieldSubtypes.add(fieldSubtype);
                    columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                }
                builder.setKind(OrcProto.Type.Kind.STRUCT);
                for (i = 0; i < fieldNames.size(); ++i) {
                    builder.addSubtypes((Integer)fieldSubtypes.get(i));
                    builder.addFieldNames(fieldNames.get(i));
                }
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            case UNION: {
                int i;
                int subtypeCount = oldType.getSubtypesCount();
                result.add(null);
                ArrayList<Integer> unionSubtypes = new ArrayList<Integer>(subtypeCount);
                for (i = 0; i < subtypeCount; ++i) {
                    int unionSubtype = result.size();
                    unionSubtypes.add(unionSubtype);
                    columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                }
                builder.setKind(OrcProto.Type.Kind.UNION);
                for (i = 0; i < subtypeCount; ++i) {
                    builder.addSubtypes((Integer)unionSubtypes.get(i));
                }
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)oldType.getKind()));
            }
        }
        if (needsAdd) {
            result.add(builder.build());
        }
        return columnId;
    }
}

