/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileMetaInfo;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.MemoryManager;
import org.apache.orc.impl.WriterImpl;

public class OrcFile {
    public static final String MAGIC = "ORC";
    public static final WriterVersion CURRENT_WRITER = WriterVersion.HIVE_13083;
    private static ThreadLocal<MemoryManager> memoryManager = null;

    protected OrcFile() {
    }

    public static ReaderOptions readerOptions(Configuration conf) {
        return new ReaderOptions(conf);
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(null, conf);
    }

    public static WriterOptions writerOptions(Properties tableProperties, Configuration conf) {
        return new WriterOptions(tableProperties, conf);
    }

    private static synchronized MemoryManager getStaticMemoryManager(final Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new ThreadLocal<MemoryManager>(){

                @Override
                protected MemoryManager initialValue() {
                    return new MemoryManager(conf);
                }
            };
        }
        return memoryManager.get();
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.getFileSystem() == null ? path.getFileSystem(opts.getConfiguration()) : opts.getFileSystem();
        return new WriterImpl(fs, path, opts);
    }

    public static class WriterOptions {
        private final Configuration configuration;
        private FileSystem fileSystemValue = null;
        private TypeDescription schema = null;
        private long stripeSizeValue;
        private long blockSizeValue;
        private int rowIndexStrideValue;
        private int bufferSizeValue;
        private boolean enforceBufferSize = false;
        private boolean blockPaddingValue;
        private CompressionKind compressValue;
        private MemoryManager memoryManagerValue;
        private Version versionValue;
        private WriterCallback callback;
        private EncodingStrategy encodingStrategy;
        private CompressionStrategy compressionStrategy;
        private double paddingTolerance;
        private String bloomFilterColumns;
        private double bloomFilterFpp;

        protected WriterOptions(Properties tableProperties, Configuration conf) {
            this.configuration = conf;
            this.memoryManagerValue = OrcFile.getStaticMemoryManager(conf);
            this.stripeSizeValue = OrcConf.STRIPE_SIZE.getLong(tableProperties, conf);
            this.blockSizeValue = OrcConf.BLOCK_SIZE.getLong(tableProperties, conf);
            this.rowIndexStrideValue = (int)OrcConf.ROW_INDEX_STRIDE.getLong(tableProperties, conf);
            this.bufferSizeValue = (int)OrcConf.BUFFER_SIZE.getLong(tableProperties, conf);
            this.blockPaddingValue = OrcConf.BLOCK_PADDING.getBoolean(tableProperties, conf);
            this.compressValue = CompressionKind.valueOf(OrcConf.COMPRESS.getString(tableProperties, conf));
            String versionName = OrcConf.WRITE_FORMAT.getString(tableProperties, conf);
            this.versionValue = Version.byName(versionName);
            String enString = OrcConf.ENCODING_STRATEGY.getString(tableProperties, conf);
            this.encodingStrategy = EncodingStrategy.valueOf(enString);
            String compString = OrcConf.COMPRESSION_STRATEGY.getString(tableProperties, conf);
            this.compressionStrategy = CompressionStrategy.valueOf(compString);
            this.paddingTolerance = OrcConf.BLOCK_PADDING_TOLERANCE.getDouble(tableProperties, conf);
            this.bloomFilterColumns = OrcConf.BLOOM_FILTER_COLUMNS.getString(tableProperties, conf);
            this.bloomFilterFpp = OrcConf.BLOOM_FILTER_FPP.getDouble(tableProperties, conf);
        }

        public WriterOptions fileSystem(FileSystem value) {
            this.fileSystemValue = value;
            return this;
        }

        public WriterOptions stripeSize(long value) {
            this.stripeSizeValue = value;
            return this;
        }

        public WriterOptions blockSize(long value) {
            this.blockSizeValue = value;
            return this;
        }

        public WriterOptions rowIndexStride(int value) {
            this.rowIndexStrideValue = value;
            return this;
        }

        public WriterOptions bufferSize(int value) {
            this.bufferSizeValue = value;
            return this;
        }

        public WriterOptions enforceBufferSize() {
            this.enforceBufferSize = true;
            return this;
        }

        public WriterOptions blockPadding(boolean value) {
            this.blockPaddingValue = value;
            return this;
        }

        public WriterOptions encodingStrategy(EncodingStrategy strategy) {
            this.encodingStrategy = strategy;
            return this;
        }

        public WriterOptions paddingTolerance(double value) {
            this.paddingTolerance = value;
            return this;
        }

        public WriterOptions bloomFilterColumns(String columns) {
            this.bloomFilterColumns = columns;
            return this;
        }

        public WriterOptions bloomFilterFpp(double fpp) {
            this.bloomFilterFpp = fpp;
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            this.compressValue = value;
            return this;
        }

        public WriterOptions setSchema(TypeDescription schema) {
            this.schema = schema;
            return this;
        }

        public WriterOptions version(Version value) {
            this.versionValue = value;
            return this;
        }

        public WriterOptions callback(WriterCallback callback) {
            this.callback = callback;
            return this;
        }

        protected WriterOptions memory(MemoryManager value) {
            this.memoryManagerValue = value;
            return this;
        }

        public boolean getBlockPadding() {
            return this.blockPaddingValue;
        }

        public long getBlockSize() {
            return this.blockSizeValue;
        }

        public String getBloomFilterColumns() {
            return this.bloomFilterColumns;
        }

        public FileSystem getFileSystem() {
            return this.fileSystemValue;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public TypeDescription getSchema() {
            return this.schema;
        }

        public long getStripeSize() {
            return this.stripeSizeValue;
        }

        public CompressionKind getCompress() {
            return this.compressValue;
        }

        public WriterCallback getCallback() {
            return this.callback;
        }

        public Version getVersion() {
            return this.versionValue;
        }

        public MemoryManager getMemoryManager() {
            return this.memoryManagerValue;
        }

        public int getBufferSize() {
            return this.bufferSizeValue;
        }

        public boolean isEnforceBufferSize() {
            return this.enforceBufferSize;
        }

        public int getRowIndexStride() {
            return this.rowIndexStrideValue;
        }

        public CompressionStrategy getCompressionStrategy() {
            return this.compressionStrategy;
        }

        public EncodingStrategy getEncodingStrategy() {
            return this.encodingStrategy;
        }

        public double getPaddingTolerance() {
            return this.paddingTolerance;
        }

        public double getBloomFilterFpp() {
            return this.bloomFilterFpp;
        }
    }

    public static interface WriterCallback {
        public void preStripeWrite(WriterContext var1) throws IOException;

        public void preFooterWrite(WriterContext var1) throws IOException;
    }

    public static interface WriterContext {
        public Writer getWriter();
    }

    public static class ReaderOptions {
        private final Configuration conf;
        private FileSystem filesystem;
        private FileMetaInfo fileMetaInfo;
        private long maxLength = Long.MAX_VALUE;
        private FileMetadata fullFileMetadata;

        public ReaderOptions(Configuration conf) {
            this.conf = conf;
        }

        public ReaderOptions fileMetaInfo(FileMetaInfo info) {
            this.fileMetaInfo = info;
            return this;
        }

        public ReaderOptions filesystem(FileSystem fs) {
            this.filesystem = fs;
            return this;
        }

        public ReaderOptions maxLength(long val) {
            this.maxLength = val;
            return this;
        }

        public ReaderOptions fileMetadata(FileMetadata metadata) {
            this.fullFileMetadata = metadata;
            return this;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public FileSystem getFilesystem() {
            return this.filesystem;
        }

        public FileMetaInfo getFileMetaInfo() {
            return this.fileMetaInfo;
        }

        public long getMaxLength() {
            return this.maxLength;
        }

        public FileMetadata getFileMetadata() {
            return this.fullFileMetadata;
        }
    }

    public static enum CompressionStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum EncodingStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum WriterVersion {
        ORIGINAL(0),
        HIVE_8732(1),
        HIVE_4243(2),
        HIVE_12055(3),
        HIVE_13083(4),
        FUTURE(Integer.MAX_VALUE);

        private final int id;
        private static final WriterVersion[] values;

        public int getId() {
            return this.id;
        }

        private WriterVersion(int id) {
            this.id = id;
        }

        public static WriterVersion from(int val) {
            if (val == WriterVersion.FUTURE.id) {
                return FUTURE;
            }
            return values[val];
        }

        static {
            int max = Integer.MIN_VALUE;
            for (WriterVersion v : WriterVersion.values()) {
                if (v.id < 0) {
                    throw new AssertionError();
                }
                if (v.id <= max || WriterVersion.FUTURE.id == v.id) continue;
                max = v.id;
            }
            values = new WriterVersion[max + 1];
            for (WriterVersion v : WriterVersion.values()) {
                if (v.id >= values.length) continue;
                WriterVersion.values[v.id] = v;
            }
        }
    }

    public static enum Version {
        V_0_11("0.11", 0, 11),
        V_0_12("0.12", 0, 12);

        public static final Version CURRENT;
        private final String name;
        private final int major;
        private final int minor;

        private Version(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public static Version byName(String name) {
            for (Version version : Version.values()) {
                if (!version.name.equals(name)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown ORC version " + name);
        }

        public String getName() {
            return this.name;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        static {
            CURRENT = V_0_12;
        }
    }
}

