/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.iotdb.tsfile.exception.compress.CompressionTypeNotSupportedException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.xerial.snappy.Snappy;

public interface ICompressor
extends Serializable {
    public static ICompressor getCompressor(String name) {
        return ICompressor.getCompressor(CompressionType.valueOf(name));
    }

    public static ICompressor getCompressor(CompressionType name) {
        if (name == null) {
            throw new CompressionTypeNotSupportedException("NULL");
        }
        switch (name) {
            case UNCOMPRESSED: {
                return new NoCompressor();
            }
            case SNAPPY: {
                return new SnappyCompressor();
            }
            case LZ4: {
                return new IOTDBLZ4Compressor();
            }
            case GZIP: {
                return new GZIPCompressor();
            }
        }
        throw new CompressionTypeNotSupportedException(name.toString());
    }

    public byte[] compress(byte[] var1) throws IOException;

    public int compress(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    public int compress(ByteBuffer var1, ByteBuffer var2) throws IOException;

    public int getMaxBytesForCompression(int var1);

    public CompressionType getType();

    public static class GZIPCompressor
    implements ICompressor {
        @Override
        public byte[] compress(byte[] data) throws IOException {
            if (null == data) {
                return new byte[0];
            }
            return GZIPCompress.compress(data);
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) throws IOException {
            byte[] dataBefore = new byte[length];
            System.arraycopy(data, offset, dataBefore, 0, length);
            byte[] res = GZIPCompress.compress(dataBefore);
            System.arraycopy(res, 0, compressed, 0, res.length);
            return res.length;
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) throws IOException {
            int length = data.remaining();
            byte[] dataBefore = new byte[length];
            data.get(dataBefore, 0, length);
            byte[] res = GZIPCompress.compress(dataBefore);
            compressed.put(res);
            return res.length;
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return Math.max(40 + uncompressedDataSize / 2, uncompressedDataSize);
        }

        @Override
        public CompressionType getType() {
            return CompressionType.GZIP;
        }
    }

    public static class GZIPCompress {
        public static byte[] compress(byte[] data) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(data);
            gzip.close();
            return out.toByteArray();
        }

        public static byte[] uncompress(byte[] data) throws IOException {
            int n;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            in.close();
            return out.toByteArray();
        }
    }

    public static class IOTDBLZ4Compressor
    implements ICompressor {
        private LZ4Compressor compressor;

        public IOTDBLZ4Compressor() {
            LZ4Factory factory = LZ4Factory.fastestInstance();
            this.compressor = factory.fastCompressor();
        }

        @Override
        public byte[] compress(byte[] data) {
            if (data == null) {
                return new byte[0];
            }
            return this.compressor.compress(data);
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) {
            return this.compressor.compress(data, offset, length, compressed, 0);
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) {
            this.compressor.compress(data, compressed);
            return data.limit();
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return this.compressor.maxCompressedLength(uncompressedDataSize);
        }

        @Override
        public CompressionType getType() {
            return CompressionType.LZ4;
        }
    }

    public static class SnappyCompressor
    implements ICompressor {
        @Override
        public byte[] compress(byte[] data) throws IOException {
            if (data == null) {
                return new byte[0];
            }
            return Snappy.compress((byte[])data);
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) throws IOException {
            return Snappy.compress((byte[])data, (int)offset, (int)length, (byte[])compressed, (int)0);
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) throws IOException {
            return Snappy.compress((ByteBuffer)data, (ByteBuffer)compressed);
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return Snappy.maxCompressedLength((int)uncompressedDataSize);
        }

        @Override
        public CompressionType getType() {
            return CompressionType.SNAPPY;
        }
    }

    public static class NoCompressor
    implements ICompressor {
        @Override
        public byte[] compress(byte[] data) {
            return data;
        }

        @Override
        public int compress(byte[] data, int offset, int length, byte[] compressed) throws IOException {
            throw new IOException("No Compressor does not support compression function");
        }

        @Override
        public int compress(ByteBuffer data, ByteBuffer compressed) throws IOException {
            throw new IOException("No Compressor does not support compression function");
        }

        @Override
        public int getMaxBytesForCompression(int uncompressedDataSize) {
            return uncompressedDataSize;
        }

        @Override
        public CompressionType getType() {
            return CompressionType.UNCOMPRESSED;
        }
    }
}

