/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BinaryStatistics
extends Statistics<Binary> {
    private Binary firstValue = new Binary("");
    private Binary lastValue = new Binary("");
    private static final String BINARY_STATS_UNSUPPORTED_MSG = "Binary statistics does not support: %s";
    static final int BINARY_STATISTICS_FIXED_RAM_SIZE = 32;

    @Override
    public TSDataType getType() {
        return TSDataType.TEXT;
    }

    @Override
    public int getStatsSize() {
        return 4 + this.firstValue.getValues().length + 4 + this.lastValue.getValues().length;
    }

    public void initializeStats(Binary first, Binary last) {
        this.firstValue = first;
        this.lastValue = last;
    }

    private void updateStats(Binary firstValue, Binary lastValue) {
        this.lastValue = lastValue;
    }

    private void updateStats(Binary firstValue, Binary lastValue, long startTime, long endTime) {
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
    }

    @Override
    public Binary getMinValue() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "min"));
    }

    @Override
    public Binary getMaxValue() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "max"));
    }

    @Override
    public Binary getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Binary getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "double sum"));
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "long sum"));
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        BinaryStatistics stringStats = (BinaryStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(stringStats.getFirstValue(), stringStats.getLastValue());
            this.isEmpty = false;
        } else {
            this.updateStats(stringStats.getFirstValue(), stringStats.getLastValue(), stats.getStartTime(), stats.getEndTime());
        }
    }

    @Override
    void updateStats(Binary value) {
        if (this.isEmpty) {
            this.initializeStats(value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    void updateStats(Binary[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public long calculateRamSize() {
        return RamUsageEstimator.sizeOf(this);
    }

    @Override
    public byte[] getMinValueBytes() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "min"));
    }

    @Override
    public byte[] getMaxValueBytes() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "max"));
    }

    @Override
    public byte[] getFirstValueBytes() {
        return this.firstValue.getValues();
    }

    @Override
    public byte[] getLastValueBytes() {
        return this.lastValue.getValues();
    }

    @Override
    public byte[] getSumValueBytes() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "sum"));
    }

    @Override
    public ByteBuffer getMinValueBuffer() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "min"));
    }

    @Override
    public ByteBuffer getMaxValueBuffer() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "max"));
    }

    @Override
    public ByteBuffer getFirstValueBuffer() {
        return ByteBuffer.wrap(this.firstValue.getValues());
    }

    @Override
    public ByteBuffer getLastValueBuffer() {
        return ByteBuffer.wrap(this.lastValue.getValues());
    }

    @Override
    public ByteBuffer getSumValueBuffer() {
        throw new StatisticsClassException(String.format(BINARY_STATS_UNSUPPORTED_MSG, "sum"));
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.firstValue = ReadWriteIOUtils.readBinary(inputStream);
        this.lastValue = ReadWriteIOUtils.readBinary(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.firstValue = ReadWriteIOUtils.readBinary(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readBinary(byteBuffer);
    }

    @Override
    public String toString() {
        return super.toString() + " [firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + "]";
    }
}

