/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BooleanStatistics
extends Statistics<Boolean> {
    private boolean firstValue;
    private boolean lastValue;
    private long sumValue;
    static final int BOOLEAN_STATISTICS_FIXED_RAM_SIZE = 56;

    @Override
    public TSDataType getType() {
        return TSDataType.BOOLEAN;
    }

    @Override
    public int getStatsSize() {
        return 10;
    }

    public void initializeStats(boolean firstValue, boolean lastValue, long sum) {
        this.firstValue = firstValue;
        this.lastValue = lastValue;
        this.sumValue = sum;
    }

    private void updateStats(boolean lastValue, long sum) {
        this.lastValue = lastValue;
        this.sumValue += sum;
    }

    private void updateStats(boolean firstValue, boolean lastValue, long startTime, long endTime, long sum) {
        if (startTime <= this.getStartTime()) {
            this.firstValue = firstValue;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = lastValue;
        }
        this.sumValue += sum;
    }

    @Override
    void updateStats(boolean value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value ? 1L : 0L);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value ? 1L : 0L);
        }
    }

    @Override
    void updateStats(boolean[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public long calculateRamSize() {
        return 56L;
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
    }

    @Override
    public Boolean getMinValue() {
        throw new StatisticsClassException("Boolean statistics does not support: min");
    }

    @Override
    public Boolean getMaxValue() {
        throw new StatisticsClassException("Boolean statistics does not support: max");
    }

    @Override
    public Boolean getFirstValue() {
        return this.firstValue;
    }

    @Override
    public Boolean getLastValue() {
        return this.lastValue;
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException("Boolean statistics does not support: double sum");
    }

    @Override
    public long getSumLongValue() {
        return this.sumValue;
    }

    @Override
    public ByteBuffer getMinValueBuffer() {
        throw new StatisticsClassException("Boolean statistics do not support: min");
    }

    @Override
    public ByteBuffer getMaxValueBuffer() {
        throw new StatisticsClassException("Boolean statistics do not support: max");
    }

    @Override
    public ByteBuffer getFirstValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.firstValue);
    }

    @Override
    public ByteBuffer getLastValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.lastValue);
    }

    @Override
    public ByteBuffer getSumValueBuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sumValue);
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        BooleanStatistics boolStats = (BooleanStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(boolStats.getFirstValue(), boolStats.getLastValue(), boolStats.sumValue);
            this.isEmpty = false;
        } else {
            this.updateStats(boolStats.getFirstValue(), boolStats.getLastValue(), stats.getStartTime(), stats.getEndTime(), boolStats.sumValue);
        }
    }

    @Override
    public byte[] getMinValueBytes() {
        throw new StatisticsClassException("Boolean statistics does not support: min");
    }

    @Override
    public byte[] getMaxValueBytes() {
        throw new StatisticsClassException("Boolean statistics does not support: max");
    }

    @Override
    public byte[] getFirstValueBytes() {
        return BytesUtils.boolToBytes(this.firstValue);
    }

    @Override
    public byte[] getLastValueBytes() {
        return BytesUtils.boolToBytes(this.lastValue);
    }

    @Override
    public byte[] getSumValueBytes() {
        return BytesUtils.longToBytes(this.sumValue);
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((Boolean)this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write((Boolean)this.lastValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.sumValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.firstValue = ReadWriteIOUtils.readBool(inputStream);
        this.lastValue = ReadWriteIOUtils.readBool(inputStream);
        this.sumValue = ReadWriteIOUtils.readLong(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.firstValue = ReadWriteIOUtils.readBool(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readBool(byteBuffer);
        this.sumValue = ReadWriteIOUtils.readLong(byteBuffer);
    }

    @Override
    public String toString() {
        return super.toString() + " [firstValue=" + this.firstValue + ", lastValue=" + this.lastValue + ", sumValue=" + this.sumValue + ']';
    }
}

