/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.util.Calendar;
import java.util.Objects;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class GroupByMonthFilter
extends GroupByFilter {
    private final boolean isSlidingStepByMonth;
    private final boolean isIntervalByMonth;
    private int slidingStepsInMo;
    private int intervalInMo;
    private final Calendar calendar = Calendar.getInstance();
    private static final long MS_TO_MONTH = 2592000000L;
    private int intervalCnt = 0;
    private final long initialStartTime;

    public GroupByMonthFilter(long interval, long slidingStep, long startTime, long endTime, boolean isSlidingStepByMonth, boolean isIntervalByMonth) {
        super(interval, slidingStep, startTime, endTime);
        this.initialStartTime = startTime;
        this.calendar.setTimeInMillis(startTime);
        this.isIntervalByMonth = isIntervalByMonth;
        this.isSlidingStepByMonth = isSlidingStepByMonth;
        if (isIntervalByMonth) {
            this.intervalInMo = (int)(interval / 2592000000L);
        }
        if (isSlidingStepByMonth) {
            this.slidingStepsInMo = (int)(slidingStep / 2592000000L);
        }
        this.getNextIntervalAndSlidingStep();
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (time < this.startTime || time >= this.endTime) {
            return false;
        }
        if (time - this.startTime < this.interval) {
            return true;
        }
        this.startTime = this.calendar.getTimeInMillis();
        this.getNextIntervalAndSlidingStep();
        return this.satisfy(time, value);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        boolean isSatisfy = this.satisfyCurrentInterval(startTime, endTime);
        if (isSatisfy) {
            return true;
        }
        long beforeStartTime = this.startTime;
        int beforeIntervalCnt = this.intervalCnt;
        while (endTime >= this.startTime && !isSatisfy) {
            this.startTime = this.calendar.getTimeInMillis();
            this.getNextIntervalAndSlidingStep();
            isSatisfy = this.satisfyCurrentInterval(startTime, endTime);
        }
        this.intervalCnt = beforeIntervalCnt - 1;
        this.startTime = beforeStartTime;
        this.getNextIntervalAndSlidingStep();
        return isSatisfy;
    }

    @Override
    public Filter copy() {
        return new GroupByMonthFilter(this.interval, this.slidingStep, this.startTime, this.endTime, this.isSlidingStepByMonth, this.isIntervalByMonth);
    }

    private boolean satisfyCurrentInterval(long startTime, long endTime) {
        if (endTime < this.startTime || startTime >= this.endTime) {
            return false;
        }
        return startTime <= this.startTime || startTime - this.startTime < this.interval;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        boolean isContained = this.isContainedByCurrentInterval(startTime, endTime);
        if (isContained) {
            return true;
        }
        long beforeStartTime = this.startTime;
        int beforeIntervalCnt = this.intervalCnt;
        while (!isContained && startTime >= this.startTime) {
            this.startTime = this.calendar.getTimeInMillis();
            this.getNextIntervalAndSlidingStep();
            isContained = this.isContainedByCurrentInterval(startTime, endTime);
        }
        this.intervalCnt = beforeIntervalCnt - 1;
        this.startTime = beforeStartTime;
        this.getNextIntervalAndSlidingStep();
        return isContained;
    }

    private boolean isContainedByCurrentInterval(long startTime, long endTime) {
        if (startTime < this.startTime || endTime > this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval && endTime - this.startTime < this.interval;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByMonthFilter)) {
            return false;
        }
        GroupByMonthFilter other = (GroupByMonthFilter)obj;
        return this.interval == other.interval && this.slidingStep == other.slidingStep && this.startTime == other.startTime && this.endTime == other.endTime && this.isSlidingStepByMonth == other.isSlidingStepByMonth && this.isIntervalByMonth == other.isIntervalByMonth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.interval, this.slidingStep, this.startTime, this.endTime, this.isSlidingStepByMonth, this.isIntervalByMonth);
    }

    private void getNextIntervalAndSlidingStep() {
        ++this.intervalCnt;
        if (this.isIntervalByMonth) {
            this.calendar.setTimeInMillis(this.initialStartTime);
            this.calendar.add(2, this.slidingStepsInMo * (this.intervalCnt - 1) + this.intervalInMo);
            this.interval = this.calendar.getTimeInMillis() - this.startTime;
        }
        if (this.isSlidingStepByMonth) {
            this.calendar.setTimeInMillis(this.initialStartTime);
            this.calendar.add(2, this.slidingStepsInMo * this.intervalCnt);
            this.slidingStep = this.calendar.getTimeInMillis() - this.startTime;
        }
    }
}

